/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marevol.utils.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexpFilenameFilter implements FilenameFilter
{
    private Pattern pattern;

    public RegexpFilenameFilter(String regexpFileName) throws PatternSyntaxException
    {
        pattern = Pattern.compile(regexpFileName);
    }

    public boolean accept(File dir, String name)
    {
        return pattern.matcher(name).matches();
    }

}
