﻿using System;

namespace Marimo.開発支援.コンソールアプリケーションライブラリ
{
    /// <summary>
    /// コンソールアプリケーションライブラリから発生させる例外のを管理します。
    /// </summary>
    internal static class 例外管理
    {

        /// <summary>
        /// エイリアスを重複して登録しようとした場合に発生させる例外です。
        /// </summary>
        public class エイリアス登録重複 : コンソールアプリケーションライブラリ例外
        {
            /// <summary>
            /// エイリアス登録重複クラスのインスタンスを生成します。
            /// </summary>
            /// <param name="エイリアス名">重複して登録しようとしたエイリアス名。</param>
            internal エイリアス登録重複(string エイリアス名)
                : base(string.Format("エイリアス「{0}」が、複数回登録されています。", エイリアス名))
            {
            }
        }

        /// <summary>
        /// コマンドキーと重複したエイリアスを登録しようとしたときに発生させる例外です。
        /// </summary>
        public class コマンドキーと重複するエイリアス登録 : コンソールアプリケーションライブラリ例外
        {
            /// <summary>
            /// キー名と重複するエイリアス登録クラスのインスタンスを生成します。
            /// </summary>
            /// <param name="コマンド名">重複して登録しようとしたコマンド名。</param>
            internal コマンドキーと重複するエイリアス登録(string コマンド名)
                : base(string.Format("同一名称のコマンドとエイリアス「{0}」が登録されています。", コマンド名))
            {
            }
        }

        /// <summary>
        /// コマンドに対応しないコマンド引数が指定された場合に発生させる例外です。
        /// </summary>
        public class コマンド引数不正 : コンソールアプリケーションライブラリ例外
        {
            /// <summary>
            /// コマンド引数不正クラスのインスタンスを生成します。
            /// </summary>
            /// <param name="args">指定されたすべてのコマンドライン引数。</param>
            internal コマンド引数不正(string[] args)
                : base(string.Format("コマンドに対応しないコマンド引数が指定されています。指定された引数は「{0}」です。", string.Join("」、「", args)))
            {
            }
        }

        /// <summary>
        /// コマンドを重複して指定しようとした場合に発生させる例外です。
        /// </summary>
        public class コマンド指定重複 : コンソールアプリケーションライブラリ例外
        {
            /// <summary>
            /// コマンド指定重複クラスのインスタンスを生成します。
            /// </summary>
            /// <param name="コマンド名">重複して登録しようとしたコマンドキー。</param>
            internal コマンド指定重複(string コマンド名)
                : base(string.Format("コマンド「{0}」が、複数回指定されています。", コマンド名))
            {
            }
        }

        /// <summary>
        /// コマンドを重複して登録しようとした場合に発生させる例外です。
        /// </summary>
        public class コマンド登録重複 : コンソールアプリケーションライブラリ例外
        {
            /// <summary>
            /// コマンド登録重複クラスのインスタンスを生成します。
            /// </summary>
            /// <param name="コマンド名"></param>
            internal コマンド登録重複(string コマンド名)
                : base(string.Format("コマンド「{0}」が、複数回登録されています。", コマンド名))
            {
            }
        }

        /// <summary>
        /// 必須であると登録されたコマンドが指定されなかったときに発生させる例外です。
        /// </summary>
        public class 必須コマンド不足 : コンソールアプリケーションライブラリ例外
        {
            /// <summary>
            /// 必須コマンド不足クラスのインスタンスを生成します。
            /// </summary>
            /// <param name="不足コマンド">必須なのに指定されなかったコマンド。</param>
            internal 必須コマンド不足(コマンド 不足コマンド)
                : base(string.Format("必須コマンド「/{0}」が指定されていません。", 不足コマンド.コマンドキー))
            {
            }
        }

        /// <summary>
        /// 登録していないコマンドが指定された場合に発生させる例外です。
        /// </summary>
        public class 未登録コマンド呼び出し : コンソールアプリケーションライブラリ例外
        {
            /// <summary>
            /// 未登録コマンド呼び出しクラスのインスタンスを生成します。
            /// </summary>
            /// <param name="コマンド名"></param>
            internal 未登録コマンド呼び出し(string コマンド名)
                : base(string.Format("コマンド「{0}」には対応していません。", コマンド名))
            {
            }
        }
    }

    /// <summary>
    /// コンソールアプリケーションライブラリから発生する例外の基底クラスとなります。
    /// </summary>
    public class コンソールアプリケーションライブラリ例外 : Exception
    {
        /// <summary>
        /// コンソールアプリケーションライブラリ例外のインスタンスを生成します。
        /// </summary>
        public コンソールアプリケーションライブラリ例外()
        {
        }

        /// <summary>
        /// コンソールアプリケーションライブラリ例外のインスタンスを生成します。
        /// </summary>
        /// <param name="メッセージ">エラーメッセージ。</param>
        public コンソールアプリケーションライブラリ例外(string メッセージ)
            : base(メッセージ)
        {
        }

        /// <summary>
        /// コンソールアプリケーションライブラリ例外のインスタンスを生成します。
        /// </summary>
        /// <param name="メッセージ">エラーメッセージ。</param>
        /// <param name="内部例外">内部例外。</param>
        public コンソールアプリケーションライブラリ例外(string メッセージ, Exception 内部例外)
            : base(メッセージ, 内部例外)
        {
        }
    }
}