/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.framework.eventdef;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.maskat.framework.BasicDef;
import org.maskat.framework.DefChildIterator;
import org.maskat.framework.eventdef.Header;
import org.maskat.framework.eventdef.Param;
import org.maskat.framework.eventdef.Result;
import org.maskat.framework.eventdef.Source;
import org.maskat.framework.eventdef.Target;

public class Event
extends BasicDef {
    private String id;
    private String ref;
    private String start;
    private String before;
    private String after;
    private String finish;
    private String type;
    private String async;
    private String remoteUrl;
    private Map headers;
    private Param param;
    private Result result;

    public Event() {
    }

    public void getRelatedObjNames(Set resultSet) {
        Iterator it;
        if (this.param != null) {
            it = this.param.getSourcesIt();
            while (it != null && it.hasNext()) {
                Source source = (Source)it.next();
                if (source.getObj() == null) continue;
                resultSet.add(source.getObj());
            }
        }
        if (this.result != null) {
            it = this.result.getTargetsIt();
            while (it != null && it.hasNext()) {
                Target target = (Target)it.next();
                if (target.getOut() == null) continue;
                resultSet.add(target.getOut());
            }
        }
    }

    public void addChild(Object child) {
        super.addChild(child);
        if (child instanceof Header) {
            this.addHeader((Header)child);
        }
        if (child instanceof Param) {
            this.setParam((Param)child);
        }
        if (child instanceof Result) {
            this.setResult((Result)child);
        }
    }

    public Event(String id) {
        this.id = id;
    }

    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public String getAsync() {
        return this.async;
    }

    public void setAsync(String async) {
        this.async = async;
    }

    public String getBefore() {
        return this.before;
    }

    public void setBefore(String before) {
        this.before = before;
    }

    public String getFinish() {
        return this.finish;
    }

    public void setFinish(String finish) {
        this.finish = finish;
    }

    public void addHeader(Header header) {
        if (header == null || header.getName() == null) {
            throw new IllegalArgumentException();
        }
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(header.getName(), header);
    }

    public Header findHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return (Header)this.headers.get(name);
    }

    public Iterator getAllHeaders() {
        if (this.headers == null) {
            return null;
        }
        return new DefChildIterator(this, this.headers.values().iterator());
    }

    public boolean hasHeaders() {
        return this.headers != null && this.headers.size() != 0;
    }

    public Param getParam() {
        return this.param;
    }

    private void setParam(Param param) {
        this.param = param;
        if (param != null) {
            param.setFromEvent(this);
        }
    }

    public Result getResult() {
        return this.result;
    }

    private void setResult(Result result) {
        this.result = result;
        if (result != null) {
            result.setFromEvent(this);
        }
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getType() {
        if (this.type == null) {
            return "remote";
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }
}

