/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.shell;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.maskat.framework.eventdef.xml.EventDefParser;
import org.maskat.ide.shell.CheckShellStarter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EventDefCheckShell {
    private CheckShellStarter starter;
    private Shell parent;
    private static List teleList;
    private static Text fileName;
    private static Text resultTxt;
    private static NodeList teleNodeList;
    private static Button fileBtn;
    private static Button checkBtn;
    private static Label label;
    private static Label listLbl;
    private static Shell shell;
    private Group group;

    static {
        shell = null;
    }

    private void initShell() {
        shell = new Shell(this.parent, 67696);
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                e.doit = false;
                shell.setVisible(false);
            }
        });
        shell.setText("\u30a4\u30d9\u30f3\u30c8\u5b9a\u7fa9XML\u30c1\u30a7\u30c3\u30af");
        this.createComponent(shell);
    }

    public Shell getShell() {
        if (shell == null) {
            this.initShell();
        }
        return shell;
    }

    public EventDefCheckShell(CheckShellStarter starter, Shell parent) {
        this.starter = starter;
        this.parent = parent;
    }

    public void showShell() {
        this.getShell();
        InputStream xmlStream = null;
        try {
            xmlStream = this.starter.getContents();
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)shell, (String)"\u30d5\u30a1\u30a4\u30eb\u958b\u304f\u5931\u6557", (String)(String.valueOf(this.starter.getName()) + "\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f\u64cd\u4f5c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (IStatus)e.getStatus());
            return;
        }
        NodeList teleNodeList = null;
        try {
            teleNodeList = EventDefParser.genTeleInstanceFromEventDef(xmlStream, "org/maskat/framework/eventdef/xml/toTeleInstance.xsl");
            if (teleNodeList == null || teleNodeList.getLength() == 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)"\u30a4\u30d9\u30f3\u30c8\u5b9a\u7fa9XML\u51e6\u7406", (String)"\u6709\u52b9\u306a\u96fb\u6587\u5b9a\u7fa9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n\u30a4\u30d9\u30f3\u30c8\u5b9a\u7fa9XML\u3067\u3042\u308b\u3053\u3068\u305d\u3057\u3066\u96fb\u6587\u5b9a\u7fa9\u304c\u3042\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(e, "\u30a4\u30d9\u30f3\u30c8\u5b9a\u7fa9XML\u51e6\u7406", "\u30a4\u30d9\u30f3\u30c8\u5b9a\u7fa9XML\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        this.resetShellData();
        this.addDataToShell(teleNodeList);
        shell.open();
    }

    private void handleException(Throwable e, String title, String message) {
        Status status = new Status(4, "org.maskat.ide.gef", 0, e.getMessage(), e);
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    private void resetShellData() {
        teleList.removeAll();
        teleNodeList = null;
        fileName.setText("");
        resultTxt.setText("");
    }

    private void createComponent(Shell shell) {
        GridLayout layout = new GridLayout(1, false);
        shell.setLayout((Layout)layout);
        this.group = new Group((Composite)shell, 0);
        GridData data = new GridData(1808);
        this.group.setLayoutData((Object)data);
        layout = new GridLayout(5, false);
        this.group.setLayout((Layout)layout);
        listLbl = new Label((Composite)this.group, 0);
        listLbl.setText("\u30a4\u30d9\u30f3\u30c8\u5b9a\u7fa9XML\u306b\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u305f\u96fb\u6587\uff1a");
        label = new Label((Composite)this.group, 0);
        label.setText("\u96fb\u6587\u30b9\u30ad\u30fc\u30de\u30d5\u30a1\u30a4\u30eb\uff1a");
        fileName = new Text((Composite)this.group, 2060);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        fileName.setLayoutData((Object)data);
        fileBtn = new Button((Composite)this.group, 8);
        fileBtn.setText("...");
        fileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EventDefCheckShell.this.getShell());
                String fileName = dialog.open();
                if (fileName != null) {
                    fileName.setText(fileName);
                }
            }
        });
        checkBtn = new Button((Composite)this.group, 8);
        checkBtn.setText("\u25cb");
        checkBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventDefCheckShell.this.doSchemaCheck();
            }
        });
        teleList = new List((Composite)this.group, 2820);
        data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        teleList.setLayoutData((Object)data);
        teleList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                EventDefCheckShell.this.doSchemaCheck();
            }
        });
        resultTxt = new Text((Composite)this.group, 2634);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 4;
        resultTxt.setLayoutData((Object)data);
    }

    private void addDataToShell(NodeList teleNodeList) {
        EventDefCheckShell.teleNodeList = teleNodeList;
        int i = 0;
        while (i < teleNodeList.getLength()) {
            Node node = teleNodeList.item(i);
            String nodeName = node.getNodeName();
            String componentName = node.getAttributes().getNamedItem("component").getNodeValue();
            String eventID = node.getAttributes().getNamedItem("event").getNodeValue();
            teleList.add(String.valueOf(componentName) + "." + eventID + "." + nodeName);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doSchemaCheck() {
        block17: {
            selectIdx = EventDefCheckShell.teleList.getSelectionIndex();
            if (selectIdx == -1) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"\u96fb\u6587", (String)"\u30ea\u30b9\u30c8\u306b\u96fb\u6587\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return;
            }
            teleID = EventDefCheckShell.teleList.getItem(selectIdx);
            teleDefNode = EventDefCheckShell.teleNodeList.item(selectIdx);
            if (teleDefNode == null) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"\u5185\u90e8\u30c7\u30fc\u30bf\u30a8\u30e9\u30fc", (String)"\u96fb\u6587\u30ce\u30fc\u30c9\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", null);
                return;
            }
            teleNode = teleDefNode.getFirstChild();
            if (teleNode == null) {
                EventDefCheckShell.resultTxt.setText(String.valueOf(teleID) + "\u306f\u7a7a\u767d\u96fb\u6587\u3067\u3059\u3002");
                return;
            }
            schemaFileName = EventDefCheckShell.fileName.getText();
            if ("".equals(schemaFileName)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"\u30b9\u30ad\u30fc\u30de\u30d5\u30a1\u30a4\u30eb", (String)"\u30b9\u30ad\u30fc\u30de\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return;
            }
            try {
                schemaXmlObj = XmlObject.Factory.parse((File)new File(schemaFileName));
            }
            catch (XmlException e) {
                this.handleException(e, "\u30b9\u30ad\u30fc\u30de\u30d1\u30fc\u30b9\u51e6\u7406", "\u30b9\u30ad\u30fc\u30de\u30d1\u30fc\u30b9\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                return;
            }
            catch (IOException e) {
                this.handleException(e, "\u30b9\u30ad\u30fc\u30de\u30d5\u30a1\u30a4\u30ebIO", "\u30b9\u30ad\u30fc\u30de\u30d5\u30a1\u30a4\u30ebIO\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                return;
            }
            sLoader = null;
            compErrors = new ArrayList<E>();
            schemaOptions = new XmlOptions();
            schemaOptions.setErrorListener(compErrors);
            try {
                sLoader = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{schemaXmlObj}, sLoader, (XmlOptions)schemaOptions);
                break block17;
            }
            catch (XmlException v0) {
                sb = new StringBuffer();
                sb.append("\u30b9\u30ad\u30fc\u30de\u30d5\u30a1\u30a4\u30eb\u30b3\u30f3\u30d1\u30a4\u30eb\u30a8\u30e9\u30fc\u3002\n\n");
                i = compErrors.iterator();
                ** while (i != null && i.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                sb.append(i.next() + "\n");
                continue;
            }
lbl45:
            // 1 sources

            EventDefCheckShell.resultTxt.setText(sb.toString());
            return;
        }
        try {
            opt = new XmlOptions().setLoadLineNumbers("LOAD_LINE_NUMBERS_END_ELEMENT");
            xmlObj = sLoader.parse(teleNode, null, opt);
        }
        catch (XmlException e) {
            this.handleException(e, "\u30b9\u30ad\u30fc\u30de\u30d0\u30ea\u30c7\u30fc\u30b7\u30e7\u30f3\u51e6\u7406", "\u30b9\u30ad\u30fc\u30de\u30d0\u30ea\u30c7\u30fc\u30b7\u30e7\u30f3\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        errors = new ArrayList<E>();
        if (xmlObj.schemaType() == XmlObject.type) {
            EventDefCheckShell.resultTxt.setText(String.valueOf(teleID) + " NOT valid.  Document type not found.");
        } else if (xmlObj.validate(new XmlOptions().setErrorListener(errors))) {
            EventDefCheckShell.resultTxt.setText(String.valueOf(teleID) + " \u691c\u8a3c\u6210\u529f.");
        } else {
            sb = new StringBuffer();
            sb.append(String.valueOf(teleID) + " \u691c\u8a3c\u5931\u6557.\n");
            i = errors.iterator();
            while (i != null && i.hasNext()) {
                sb.append(i.next() + "\n");
            }
            EventDefCheckShell.resultTxt.setText(sb.toString());
        }
    }
}

