package org.maskat.demo.petstore;
import java.sql.*;
import java.util.*;

public class ItemDAO {

	private Connection con = null;
	
	public ItemDAO(Connection con){
		this.con = con;
	}
	
	public Vector findItems(String productId) throws SQLException{
	
		Vector ret = null;
		String sql = null;
		ResultSet rs = null;
		
		try{
			sql = "select * from item where ProductID=?";
			PreparedStatement stmt = null;
			stmt = con.prepareStatement(sql);
			stmt.setString(1,productId);
			rs = stmt.executeQuery();
			ret = new Vector();
			
			while(rs.next()){
				Item obj= new Item(rs.getString("ItemID"), rs.getString("ProductID"), rs.getString("Description"), rs.getInt("Price"), rs.getString("ImgURL"), rs.getString("Account"));
				ret.addElement(obj);
			}
			
			rs.close();
			
		}catch(Exception e){
		      e.printStackTrace();
		}
		
		return ret;
			
	}
	
		public Vector findItem(String itemId) throws SQLException{
	
		Vector ret = null;
		String sql = null;
		ResultSet rs = null;
		
		try{
			sql = "select * from item where ItemID=?";
			PreparedStatement stmt = null;
			stmt = con.prepareStatement(sql);
			stmt.setString(1,itemId);
			rs = stmt.executeQuery();
			ret = new Vector();
			
			while(rs.next()){
				Item obj= new Item(rs.getString("ItemID"), rs.getString("ProductID"), rs.getString("Description"), rs.getInt("Price"), rs.getString("ImgURL"), rs.getString("Account"));
				ret.addElement(obj);
			}
			
			rs.close();
			
		}catch(Exception e){
		      e.printStackTrace();
		}
		
		return ret;
			
	}
}