/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StateMessageDatatype;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;

public class IDREFDatatypeValidator
extends StringDatatypeValidator {
    private static StringDatatypeValidator fgStrValidator = null;
    private static Object fNullValue = null;
    protected static Hashtable fTableOfId = null;
    private static Hashtable fTableIDRefs = null;
    public static final int IDREF_STORE = 0;
    public static final int IDREF_CLEAR = 1;
    public static final int IDREF_VALIDATE = 2;

    public IDREFDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public IDREFDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
        Cloneable cloneable;
        if (bl) {
            return;
        }
        if (fgStrValidator == null) {
            cloneable = new Hashtable<String, String>();
            ((Hashtable)cloneable).put("whiteSpace", "collapse");
            ((Hashtable)cloneable).put("pattern", "[\\i-[:]][\\c-[:]]*");
            fgStrValidator = new StringDatatypeValidator(null, (Hashtable)cloneable, false);
        }
        cloneable = null;
        if (hashtable != null) {
            cloneable = (Vector)hashtable.get("enumeration");
        }
        if (cloneable != null) {
            int n = 0;
            try {
                while (n < ((Vector)cloneable).size()) {
                    fgStrValidator.validate((String)((Vector)cloneable).elementAt(n), null);
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new InvalidDatatypeFacetException("Value of enumeration = '" + ((Vector)cloneable).elementAt(n) + "' must be from the value space of base.");
            }
        }
    }

    private void addIdRef(String string, Object object) {
        if (fTableOfId != null && fTableOfId.containsKey(string)) {
            return;
        }
        if (fTableIDRefs == null) {
            fTableIDRefs = new Hashtable();
        } else if (fTableIDRefs.containsKey(string)) {
            return;
        }
        if (fNullValue == null) {
            fNullValue = new Object();
        }
        try {
            fTableIDRefs.put(string, fNullValue);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Out of Memory: Hashtable of ID's has " + fTableIDRefs.size() + " Elements");
            outOfMemoryError.printStackTrace();
        }
    }

    private void checkIdRefs() throws InvalidDatatypeValueException {
        if (fTableIDRefs == null) {
            return;
        }
        Enumeration enumeration = fTableIDRefs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (fTableOfId != null && fTableOfId.containsKey(string)) continue;
            InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException(string);
            invalidDatatypeValueException.setMinorCode(81);
            invalidDatatypeValueException.setMajorCode(2);
            throw invalidDatatypeValueException;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public int compare(String string, String string2) {
        return -1;
    }

    public short getWSFacet() {
        return fgStrValidator.getWSFacet();
    }

    protected void resetIDRefs() {
        if (fTableOfId != null) {
            fTableOfId.clear();
            fTableOfId = null;
        }
        if (fTableIDRefs != null) {
            fTableIDRefs.clear();
            fTableIDRefs = null;
        }
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        if (object != null) {
            StateMessageDatatype stateMessageDatatype = (StateMessageDatatype)object;
            if (stateMessageDatatype.getDatatypeState() == 1) {
                if (fTableOfId != null) {
                    fTableOfId.clear();
                    fTableOfId = null;
                }
                if (fTableIDRefs != null) {
                    fTableIDRefs.clear();
                    fTableIDRefs = null;
                }
            } else if (stateMessageDatatype.getDatatypeState() == 2) {
                this.checkIdRefs();
            } else if (stateMessageDatatype.getDatatypeState() == 0) {
                fTableOfId = (Hashtable)stateMessageDatatype.getDatatypeObject();
            }
            return null;
        }
        super.validate(string, object);
        try {
            fgStrValidator.validate(string, null);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            InvalidDatatypeValueException invalidDatatypeValueException2 = new InvalidDatatypeValueException("IDREF is not valid: " + string);
            invalidDatatypeValueException2.setMinorCode(77);
            invalidDatatypeValueException2.setMajorCode(2);
            throw invalidDatatypeValueException2;
        }
        this.addIdRef(string, object);
        return null;
    }
}

