/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import java.util.Vector;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.validators.schema.identity.XPathException;

public class XPath {
    private static final boolean DEBUG_ALL = false;
    private static final boolean DEBUG_XPATH_PARSE = false;
    private static final boolean DEBUG_ANY = false;
    protected String fExpression;
    protected StringPool fStringPool;
    protected LocationPath[] fLocationPaths;

    public XPath(String string, StringPool stringPool, NamespacesScope namespacesScope) throws XPathException {
        XMLCharacterProperties.initCharFlags();
        this.fExpression = string;
        this.fStringPool = stringPool;
        this.parseExpression(namespacesScope);
    }

    public LocationPath getLocationPath() {
        return (LocationPath)this.fLocationPaths[0].clone();
    }

    public LocationPath[] getLocationPaths() {
        LocationPath[] locationPathArray = new LocationPath[this.fLocationPaths.length];
        int n = 0;
        while (n < this.fLocationPaths.length) {
            locationPathArray[n] = (LocationPath)this.fLocationPaths[n].clone();
            ++n;
        }
        return locationPathArray;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            System.out.println("# XPath expression: \"" + string + '\"');
            try {
                StringPool stringPool = new StringPool();
                XPath xPath = new XPath(string, stringPool, null);
                System.out.println("expanded xpath: \"" + xPath.toString() + '\"');
            }
            catch (XPathException xPathException) {
                System.out.println("error: " + xPathException.getMessage());
            }
            ++n;
        }
    }

    private void parseExpression(NamespacesScope namespacesScope) throws XPathException {
        int n;
        Tokens tokens = new Tokens(this.fStringPool);
        Scanner scanner = new Scanner(this.fStringPool){

            protected void addToken(Tokens tokens, int n) throws XPathException {
                if (n == 6 || n == 35 || n == 36 || n == 8 || n == 11 || n == 21 || n == 4 || n == 9 || n == 10 || n == 22 || n == 23) {
                    super.addToken(tokens, n);
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("token not supported: ");
                String string = tokens.getTokenName(n);
                if (string != null) {
                    stringBuffer.append('\"');
                    stringBuffer.append(string);
                    stringBuffer.append('\"');
                } else {
                    stringBuffer.append('(');
                    stringBuffer.append(n);
                    stringBuffer.append(')');
                }
                String string2 = stringBuffer.toString();
                throw new XPathException(string2);
            }
        };
        int n2 = this.fExpression.length();
        boolean bl = scanner.scanExpr(this.fStringPool, tokens, this.fExpression, 0, n2);
        Vector<Cloneable> vector = new Vector<Cloneable>();
        Vector<LocationPath> vector2 = new Vector<LocationPath>();
        int n3 = tokens.getTokenCount();
        boolean bl2 = true;
        int n4 = 0;
        while (n4 < n3) {
            n = tokens.getToken(n4);
            boolean bl3 = false;
            switch (n) {
                case 23: {
                    if (n4 == 0) {
                        throw new XPathException("not allowed to have '|' here");
                    }
                    int n5 = vector.size();
                    if (n5 == 0) {
                        throw new XPathException("not allowed to have '||'");
                    }
                    Object[] objectArray = new Step[n5];
                    vector.copyInto(objectArray);
                    vector2.add(new LocationPath((Step[])objectArray));
                    vector.clear();
                    bl2 = true;
                    break;
                }
                case 35: {
                    ++n4;
                }
                case 6: {
                    Cloneable cloneable;
                    Cloneable cloneable2;
                    Cloneable cloneable3;
                    if (n4 == n3 - 1) {
                        throw new XPathException("missing attribute name");
                    }
                    if ((n = tokens.getToken(++n4)) != 11 && n != 9 && n != 10) {
                        throw new XPathException("expected \"" + tokens.getTokenName(11) + "\" or \"" + tokens.getTokenName(9) + "\" or \"" + tokens.getTokenName(10) + "\", found " + tokens.getTokenName(n));
                    }
                    boolean bl4 = false;
                    switch (n) {
                        case 9: {
                            Axis axis = new Axis(2);
                            NodeTest nodeTest = new NodeTest(2);
                            Step step = new Step(axis, nodeTest);
                            vector.addElement(step);
                            break;
                        }
                        case 10: {
                            bl4 = true;
                        }
                        case 11: {
                            n = tokens.getToken(++n4);
                            int n6 = tokens.getTokenString(n);
                            int n7 = 0;
                            if (namespacesScope != null && n6 != -1) {
                                n7 = namespacesScope.getNamespaceForPrefix(n6);
                            }
                            if (n6 != -1 && namespacesScope != null && n7 == 0) {
                                throw new XPathException("prefix " + this.fStringPool.toString(n6) + " not bound to namespace URI");
                            }
                            if (bl4) {
                                Axis axis = new Axis(2);
                                cloneable3 = new NodeTest(this.fStringPool, n6, n7);
                                cloneable2 = new Step(axis, (NodeTest)cloneable3);
                                vector.addElement(cloneable2);
                                break;
                            }
                            n = tokens.getToken(++n4);
                            int n8 = tokens.getTokenString(n);
                            int n9 = n6 != -1 ? this.fStringPool.addSymbol(String.valueOf(this.fStringPool.toString(n6)) + ':' + this.fStringPool.toString(n8)) : n8;
                            cloneable2 = new Axis(2);
                            cloneable = new NodeTest(this.fStringPool, new QName(n6, n8, n9, n7));
                            Step step = new Step((Axis)cloneable2, (NodeTest)cloneable);
                            vector.addElement(step);
                            break;
                        }
                    }
                    bl2 = false;
                    break;
                }
                case 8: {
                    throw new XPathException("Not allowed to have double colon here");
                }
                case 36: {
                    if (++n4 == n3 - 1) {
                        throw new XPathException("expected step following '" + tokens.getTokenName(36) + "::'");
                    }
                    bl2 = false;
                    break;
                }
                case 9: {
                    Axis axis = new Axis(1);
                    NodeTest nodeTest = new NodeTest(2);
                    Step step = new Step(axis, nodeTest);
                    vector.addElement(step);
                    bl2 = false;
                    break;
                }
                case 10: {
                    bl3 = true;
                }
                case 11: {
                    Cloneable cloneable3;
                    n = tokens.getToken(++n4);
                    int n10 = tokens.getTokenString(n);
                    int n11 = 0;
                    if (namespacesScope != null && n10 != -1) {
                        n11 = namespacesScope.getNamespaceForPrefix(n10);
                    }
                    if (n10 != -1 && namespacesScope != null && n11 == 0) {
                        throw new XPathException("prefix " + this.fStringPool.toString(n10) + " not bound to namespace URI");
                    }
                    if (bl3) {
                        Axis axis = new Axis(1);
                        NodeTest nodeTest = new NodeTest(this.fStringPool, n10, n11);
                        cloneable3 = new Step(axis, nodeTest);
                        vector.addElement(cloneable3);
                        break;
                    }
                    n = tokens.getToken(++n4);
                    int n12 = tokens.getTokenString(n);
                    int n13 = n10 != -1 ? this.fStringPool.addSymbol(String.valueOf(this.fStringPool.toString(n10)) + ':' + this.fStringPool.toString(n12)) : n12;
                    cloneable3 = new Axis(1);
                    Cloneable cloneable2 = new NodeTest(this.fStringPool, new QName(n10, n12, n13, n11));
                    Cloneable cloneable = new Step((Axis)cloneable3, (NodeTest)cloneable2);
                    vector.addElement(cloneable);
                    bl2 = false;
                    break;
                }
                case 4: {
                    Axis axis = new Axis(3);
                    NodeTest nodeTest = new NodeTest(3);
                    Step step = new Step(axis, nodeTest);
                    vector.addElement(step);
                    if (bl2 && n4 + 1 < n3 && (n = tokens.getToken(n4 + 1)) == 22) {
                        if (++n4 == n3 - 1) {
                            throw new XPathException("expected step following '//'");
                        }
                        if (n4 + 1 < n3 && (n = tokens.getToken(n4 + 1)) == 21) {
                            throw new XPathException("'/' not allowed after '//'");
                        }
                        axis = new Axis(4);
                        nodeTest = new NodeTest(3);
                        step = new Step(axis, nodeTest);
                        vector.addElement(step);
                    }
                    bl2 = false;
                    break;
                }
                case 22: {
                    throw new XPathException("'//' only allowed after '.' at the beginning of an xpath");
                }
                case 21: {
                    if (bl2) {
                        throw new XPathException("not allowed to select the root");
                    }
                    if (n4 == n3 - 1) {
                        throw new XPathException("expected step following '/'");
                    }
                    bl2 = false;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            ++n4;
        }
        n = vector.size();
        if (n == 0) {
            if (vector2.size() == 0) {
                throw new XPathException("empty xpath expression");
            }
            throw new XPathException("xpath cannot end with '|'");
        }
        Object[] objectArray = new Step[n];
        vector.copyInto(objectArray);
        vector2.add(new LocationPath((Step[])objectArray));
        this.fLocationPaths = new LocationPath[vector2.size()];
        vector2.copyInto(this.fLocationPaths);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.fLocationPaths.length) {
            if (n > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(this.fLocationPaths[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public static class LocationPath
    implements Cloneable {
        public Step[] steps;

        protected LocationPath(LocationPath locationPath) {
            this.steps = new Step[locationPath.steps.length];
            int n = 0;
            while (n < this.steps.length) {
                this.steps[n] = (Step)locationPath.steps[n].clone();
                ++n;
            }
        }

        public LocationPath(Step[] stepArray) {
            this.steps = stepArray;
        }

        public Object clone() {
            return new LocationPath(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.steps.length) {
                if (n > 0 && this.steps[n - 1].axis.type != 4 && this.steps[n].axis.type != 4) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(this.steps[n].toString());
                ++n;
            }
            return stringBuffer.toString();
        }
    }

    public static class Step
    implements Cloneable {
        public Axis axis;
        public NodeTest nodeTest;

        public Step(Axis axis, NodeTest nodeTest) {
            this.axis = axis;
            this.nodeTest = nodeTest;
        }

        protected Step(Step step) {
            this.axis = (Axis)step.axis.clone();
            this.nodeTest = (NodeTest)step.nodeTest.clone();
        }

        public Object clone() {
            return new Step(this);
        }

        public String toString() {
            if (this.axis.type == 3) {
                return ".";
            }
            if (this.axis.type == 2) {
                return "@" + this.nodeTest.toString();
            }
            if (this.axis.type == 1) {
                return this.nodeTest.toString();
            }
            if (this.axis.type == 4) {
                return "//";
            }
            return "??? (" + this.axis.type + ')';
        }
    }

    public static class Axis
    implements Cloneable {
        public static final short CHILD = 1;
        public static final short ATTRIBUTE = 2;
        public static final short SELF = 3;
        public static final short DESCENDANT = 4;
        public short type;

        protected Axis(Axis axis) {
            this.type = axis.type;
        }

        public Axis(short s) {
            this.type = s;
        }

        public Object clone() {
            return new Axis(this);
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "child";
                }
                case 2: {
                    return "attribute";
                }
                case 3: {
                    return "self";
                }
                case 4: {
                    return "descendant";
                }
            }
            return "???";
        }
    }

    public static class NodeTest
    implements Cloneable {
        public static final short QNAME = 1;
        public static final short WILDCARD = 2;
        public static final short NODE = 3;
        public static final short NAMESPACE = 4;
        protected StringPool fStringPool;
        public short type;
        public final QName name = new QName();

        public NodeTest(StringPool stringPool, int n, int n2) {
            this.fStringPool = stringPool;
            this.type = (short)4;
            this.name.setValues(n, -1, -1, n2);
        }

        public NodeTest(StringPool stringPool, QName qName) {
            this.fStringPool = stringPool;
            this.type = 1;
            this.name.setValues(qName);
        }

        public NodeTest(NodeTest nodeTest) {
            this.fStringPool = nodeTest.fStringPool;
            this.type = nodeTest.type;
            this.name.setValues(nodeTest.name);
        }

        public NodeTest(short s) {
            this.type = s;
        }

        public Object clone() {
            return new NodeTest(this);
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    if (this.name.prefix != -1) {
                        if (this.name.uri == 0) {
                            return String.valueOf(this.fStringPool.toString(this.name.prefix)) + ':' + this.fStringPool.toString(this.name.localpart);
                        }
                        return "{" + this.fStringPool.toString(this.name.uri) + '}' + this.fStringPool.toString(this.name.prefix) + ':' + this.fStringPool.toString(this.name.localpart);
                    }
                    return this.fStringPool.toString(this.name.localpart);
                }
                case 4: {
                    if (this.name.prefix != -1) {
                        if (this.name.uri == 0) {
                            return String.valueOf(this.fStringPool.toString(this.name.prefix)) + ":*";
                        }
                        return "{" + this.fStringPool.toString(this.name.uri) + '}' + this.fStringPool.toString(this.name.prefix) + ":*";
                    }
                    return "???:*";
                }
                case 2: {
                    return "*";
                }
                case 3: {
                    return "node()";
                }
            }
            return "???";
        }
    }

    private static final class Tokens {
        static final boolean DUMP_TOKENS = false;
        public static final int EXPRTOKEN_OPEN_PAREN = 0;
        public static final int EXPRTOKEN_CLOSE_PAREN = 1;
        public static final int EXPRTOKEN_OPEN_BRACKET = 2;
        public static final int EXPRTOKEN_CLOSE_BRACKET = 3;
        public static final int EXPRTOKEN_PERIOD = 4;
        public static final int EXPRTOKEN_DOUBLE_PERIOD = 5;
        public static final int EXPRTOKEN_ATSIGN = 6;
        public static final int EXPRTOKEN_COMMA = 7;
        public static final int EXPRTOKEN_DOUBLE_COLON = 8;
        public static final int EXPRTOKEN_NAMETEST_ANY = 9;
        public static final int EXPRTOKEN_NAMETEST_NAMESPACE = 10;
        public static final int EXPRTOKEN_NAMETEST_QNAME = 11;
        public static final int EXPRTOKEN_NODETYPE_COMMENT = 12;
        public static final int EXPRTOKEN_NODETYPE_TEXT = 13;
        public static final int EXPRTOKEN_NODETYPE_PI = 14;
        public static final int EXPRTOKEN_NODETYPE_NODE = 15;
        public static final int EXPRTOKEN_OPERATOR_AND = 16;
        public static final int EXPRTOKEN_OPERATOR_OR = 17;
        public static final int EXPRTOKEN_OPERATOR_MOD = 18;
        public static final int EXPRTOKEN_OPERATOR_DIV = 19;
        public static final int EXPRTOKEN_OPERATOR_MULT = 20;
        public static final int EXPRTOKEN_OPERATOR_SLASH = 21;
        public static final int EXPRTOKEN_OPERATOR_DOUBLE_SLASH = 22;
        public static final int EXPRTOKEN_OPERATOR_UNION = 23;
        public static final int EXPRTOKEN_OPERATOR_PLUS = 24;
        public static final int EXPRTOKEN_OPERATOR_MINUS = 25;
        public static final int EXPRTOKEN_OPERATOR_EQUAL = 26;
        public static final int EXPRTOKEN_OPERATOR_NOT_EQUAL = 27;
        public static final int EXPRTOKEN_OPERATOR_LESS = 28;
        public static final int EXPRTOKEN_OPERATOR_LESS_EQUAL = 29;
        public static final int EXPRTOKEN_OPERATOR_GREATER = 30;
        public static final int EXPRTOKEN_OPERATOR_GREATER_EQUAL = 31;
        public static final int EXPRTOKEN_FUNCTION_NAME = 32;
        public static final int EXPRTOKEN_AXISNAME_ANCESTOR = 33;
        public static final int EXPRTOKEN_AXISNAME_ANCESTOR_OR_SELF = 34;
        public static final int EXPRTOKEN_AXISNAME_ATTRIBUTE = 35;
        public static final int EXPRTOKEN_AXISNAME_CHILD = 36;
        public static final int EXPRTOKEN_AXISNAME_DESCENDANT = 37;
        public static final int EXPRTOKEN_AXISNAME_DESCENDANT_OR_SELF = 38;
        public static final int EXPRTOKEN_AXISNAME_FOLLOWING = 39;
        public static final int EXPRTOKEN_AXISNAME_FOLLOWING_SIBLING = 40;
        public static final int EXPRTOKEN_AXISNAME_NAMESPACE = 41;
        public static final int EXPRTOKEN_AXISNAME_PARENT = 42;
        public static final int EXPRTOKEN_AXISNAME_PRECEDING = 43;
        public static final int EXPRTOKEN_AXISNAME_PRECEDING_SIBLING = 44;
        public static final int EXPRTOKEN_AXISNAME_SELF = 45;
        public static final int EXPRTOKEN_LITERAL = 46;
        public static final int EXPRTOKEN_NUMBER = 47;
        public static final int EXPRTOKEN_VARIABLE_REFERENCE = 48;
        public static final String[] fgTokenNames = new String[]{"EXPRTOKEN_OPEN_PAREN", "EXPRTOKEN_CLOSE_PAREN", "EXPRTOKEN_OPEN_BRACKET", "EXPRTOKEN_CLOSE_BRACKET", "EXPRTOKEN_PERIOD", "EXPRTOKEN_DOUBLE_PERIOD", "EXPRTOKEN_ATSIGN", "EXPRTOKEN_COMMA", "EXPRTOKEN_DOUBLE_COLON", "EXPRTOKEN_NAMETEST_ANY", "EXPRTOKEN_NAMETEST_NAMESPACE", "EXPRTOKEN_NAMETEST_QNAME", "EXPRTOKEN_NODETYPE_COMMENT", "EXPRTOKEN_NODETYPE_TEXT", "EXPRTOKEN_NODETYPE_PI", "EXPRTOKEN_NODETYPE_NODE", "EXPRTOKEN_OPERATOR_AND", "EXPRTOKEN_OPERATOR_OR", "EXPRTOKEN_OPERATOR_MOD", "EXPRTOKEN_OPERATOR_DIV", "EXPRTOKEN_OPERATOR_MULT", "EXPRTOKEN_OPERATOR_SLASH", "EXPRTOKEN_OPERATOR_DOUBLE_SLASH", "EXPRTOKEN_OPERATOR_UNION", "EXPRTOKEN_OPERATOR_PLUS", "EXPRTOKEN_OPERATOR_MINUS", "EXPRTOKEN_OPERATOR_EQUAL", "EXPRTOKEN_OPERATOR_NOT_EQUAL", "EXPRTOKEN_OPERATOR_LESS", "EXPRTOKEN_OPERATOR_LESS_EQUAL", "EXPRTOKEN_OPERATOR_GREATER", "EXPRTOKEN_OPERATOR_GREATER_EQUAL", "EXPRTOKEN_FUNCTION_NAME", "EXPRTOKEN_AXISNAME_ANCESTOR", "EXPRTOKEN_AXISNAME_ANCESTOR_OR_SELF", "EXPRTOKEN_AXISNAME_ATTRIBUTE", "EXPRTOKEN_AXISNAME_CHILD", "EXPRTOKEN_AXISNAME_DESCENDANT", "EXPRTOKEN_AXISNAME_DESCENDANT_OR_SELF", "EXPRTOKEN_AXISNAME_FOLLOWING", "EXPRTOKEN_AXISNAME_FOLLOWING_SIBLING", "EXPRTOKEN_AXISNAME_NAMESPACE", "EXPRTOKEN_AXISNAME_PARENT", "EXPRTOKEN_AXISNAME_PRECEDING", "EXPRTOKEN_AXISNAME_PRECEDING_SIBLING", "EXPRTOKEN_AXISNAME_SELF", "EXPRTOKEN_LITERAL", "EXPRTOKEN_NUMBER", "EXPRTOKEN_VARIABLE_REFERENCE"};
        private static final int INITIAL_TOKEN_COUNT = 256;
        private int[] fTokens = new int[256];
        private int fTokenCount = 0;
        private StringPool fStringPool;

        public Tokens(StringPool stringPool) {
            this.fStringPool = stringPool;
        }

        public void addToken(int n) {
            try {
                this.fTokens[this.fTokenCount] = n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[] nArray = this.fTokens;
                this.fTokens = new int[this.fTokenCount << 1];
                System.arraycopy(nArray, 0, this.fTokens, 0, this.fTokenCount);
                this.fTokens[this.fTokenCount] = n;
            }
            ++this.fTokenCount;
        }

        public void dumpTokens() {
            int n = 0;
            while (n < this.fTokenCount) {
                switch (this.fTokens[n]) {
                    case 0: {
                        System.out.print("<OPEN_PAREN/>");
                        break;
                    }
                    case 1: {
                        System.out.print("<CLOSE_PAREN/>");
                        break;
                    }
                    case 2: {
                        System.out.print("<OPEN_BRACKET/>");
                        break;
                    }
                    case 3: {
                        System.out.print("<CLOSE_BRACKET/>");
                        break;
                    }
                    case 4: {
                        System.out.print("<PERIOD/>");
                        break;
                    }
                    case 5: {
                        System.out.print("<DOUBLE_PERIOD/>");
                        break;
                    }
                    case 6: {
                        System.out.print("<ATSIGN/>");
                        break;
                    }
                    case 7: {
                        System.out.print("<COMMA/>");
                        break;
                    }
                    case 8: {
                        System.out.print("<DOUBLE_COLON/>");
                        break;
                    }
                    case 9: {
                        System.out.print("<NAMETEST_ANY/>");
                        break;
                    }
                    case 10: {
                        System.out.print("<NAMETEST_NAMESPACE");
                        System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case 11: {
                        System.out.print("<NAMETEST_QNAME");
                        if (this.fTokens[++n] != -1) {
                            System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[n]) + "\"");
                        }
                        System.out.print(" localpart=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case 12: {
                        System.out.print("<NODETYPE_COMMENT/>");
                        break;
                    }
                    case 13: {
                        System.out.print("<NODETYPE_TEXT/>");
                        break;
                    }
                    case 14: {
                        System.out.print("<NODETYPE_PI/>");
                        break;
                    }
                    case 15: {
                        System.out.print("<NODETYPE_NODE/>");
                        break;
                    }
                    case 16: {
                        System.out.print("<OPERATOR_AND/>");
                        break;
                    }
                    case 17: {
                        System.out.print("<OPERATOR_OR/>");
                        break;
                    }
                    case 18: {
                        System.out.print("<OPERATOR_MOD/>");
                        break;
                    }
                    case 19: {
                        System.out.print("<OPERATOR_DIV/>");
                        break;
                    }
                    case 20: {
                        System.out.print("<OPERATOR_MULT/>");
                        break;
                    }
                    case 21: {
                        System.out.print("<OPERATOR_SLASH/>");
                        if (n + 1 >= this.fTokenCount) break;
                        System.out.println();
                        System.out.print("  ");
                        break;
                    }
                    case 22: {
                        System.out.print("<OPERATOR_DOUBLE_SLASH/>");
                        break;
                    }
                    case 23: {
                        System.out.print("<OPERATOR_UNION/>");
                        break;
                    }
                    case 24: {
                        System.out.print("<OPERATOR_PLUS/>");
                        break;
                    }
                    case 25: {
                        System.out.print("<OPERATOR_MINUS/>");
                        break;
                    }
                    case 26: {
                        System.out.print("<OPERATOR_EQUAL/>");
                        break;
                    }
                    case 27: {
                        System.out.print("<OPERATOR_NOT_EQUAL/>");
                        break;
                    }
                    case 28: {
                        System.out.print("<OPERATOR_LESS/>");
                        break;
                    }
                    case 29: {
                        System.out.print("<OPERATOR_LESS_EQUAL/>");
                        break;
                    }
                    case 30: {
                        System.out.print("<OPERATOR_GREATER/>");
                        break;
                    }
                    case 31: {
                        System.out.print("<OPERATOR_GREATER_EQUAL/>");
                        break;
                    }
                    case 32: {
                        System.out.print("<FUNCTION_NAME");
                        if (this.fTokens[++n] != -1) {
                            System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[n]) + "\"");
                        }
                        System.out.print(" localpart=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case 33: {
                        System.out.print("<AXISNAME_ANCESTOR/>");
                        break;
                    }
                    case 34: {
                        System.out.print("<AXISNAME_ANCESTOR_OR_SELF/>");
                        break;
                    }
                    case 35: {
                        System.out.print("<AXISNAME_ATTRIBUTE/>");
                        break;
                    }
                    case 36: {
                        System.out.print("<AXISNAME_CHILD/>");
                        break;
                    }
                    case 37: {
                        System.out.print("<AXISNAME_DESCENDANT/>");
                        break;
                    }
                    case 38: {
                        System.out.print("<AXISNAME_DESCENDANT_OR_SELF/>");
                        break;
                    }
                    case 39: {
                        System.out.print("<AXISNAME_FOLLOWING/>");
                        break;
                    }
                    case 40: {
                        System.out.print("<AXISNAME_FOLLOWING_SIBLING/>");
                        break;
                    }
                    case 41: {
                        System.out.print("<AXISNAME_NAMESPACE/>");
                        break;
                    }
                    case 42: {
                        System.out.print("<AXISNAME_PARENT/>");
                        break;
                    }
                    case 43: {
                        System.out.print("<AXISNAME_PRECEDING/>");
                        break;
                    }
                    case 44: {
                        System.out.print("<AXISNAME_PRECEDING_SIBLING/>");
                        break;
                    }
                    case 45: {
                        System.out.print("<AXISNAME_SELF/>");
                        break;
                    }
                    case 46: {
                        System.out.print("<LITERAL");
                        System.out.print(" value=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case 47: {
                        System.out.print("<NUMBER");
                        System.out.print(" whole=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print(" part=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case 48: {
                        System.out.print("<VARIABLE_REFERENCE");
                        if (this.fTokens[++n] != -1) {
                            System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[n]) + "\"");
                        }
                        System.out.print(" localpart=\"" + this.getTokenString(this.fTokens[++n]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    default: {
                        System.out.println("<???/>");
                    }
                }
                ++n;
            }
            System.out.println();
        }

        public int getToken(int n) {
            return this.fTokens[n];
        }

        public int getTokenCount() {
            return this.fTokenCount;
        }

        public String getTokenName(int n) {
            if (n < 0 || n >= fgTokenNames.length) {
                return null;
            }
            return fgTokenNames[n];
        }

        public int getTokenString(int n) {
            return n;
        }
    }

    private static class Scanner {
        private static final byte CHARTYPE_INVALID = 0;
        private static final byte CHARTYPE_OTHER = 1;
        private static final byte CHARTYPE_WHITESPACE = 2;
        private static final byte CHARTYPE_EXCLAMATION = 3;
        private static final byte CHARTYPE_QUOTE = 4;
        private static final byte CHARTYPE_DOLLAR = 5;
        private static final byte CHARTYPE_OPEN_PAREN = 6;
        private static final byte CHARTYPE_CLOSE_PAREN = 7;
        private static final byte CHARTYPE_STAR = 8;
        private static final byte CHARTYPE_PLUS = 9;
        private static final byte CHARTYPE_COMMA = 10;
        private static final byte CHARTYPE_MINUS = 11;
        private static final byte CHARTYPE_PERIOD = 12;
        private static final byte CHARTYPE_SLASH = 13;
        private static final byte CHARTYPE_DIGIT = 14;
        private static final byte CHARTYPE_COLON = 15;
        private static final byte CHARTYPE_LESS = 16;
        private static final byte CHARTYPE_EQUAL = 17;
        private static final byte CHARTYPE_GREATER = 18;
        private static final byte CHARTYPE_ATSIGN = 19;
        private static final byte CHARTYPE_LETTER = 20;
        private static final byte CHARTYPE_OPEN_BRACKET = 21;
        private static final byte CHARTYPE_CLOSE_BRACKET = 22;
        private static final byte CHARTYPE_UNDERSCORE = 23;
        private static final byte CHARTYPE_UNION = 24;
        private static final byte CHARTYPE_NONASCII = 25;
        private static byte[] fASCIICharMap;
        private StringPool fStringPool;
        private int fAndSymbol;
        private int fOrSymbol;
        private int fModSymbol;
        private int fDivSymbol;
        private int fCommentSymbol;
        private int fTextSymbol;
        private int fPISymbol;
        private int fNodeSymbol;
        private int fAncestorSymbol;
        private int fAncestorOrSelfSymbol;
        private int fAttributeSymbol;
        private int fChildSymbol;
        private int fDescendantSymbol;
        private int fDescendantOrSelfSymbol;
        private int fFollowingSymbol;
        private int fFollowingSiblingSymbol;
        private int fNamespaceSymbol;
        private int fParentSymbol;
        private int fPrecedingSymbol;
        private int fPrecedingSiblingSymbol;
        private int fSelfSymbol;

        static {
            byte[] byArray = new byte[128];
            byArray[9] = 2;
            byArray[10] = 2;
            byArray[13] = 2;
            byArray[32] = 2;
            byArray[33] = 3;
            byArray[34] = 4;
            byArray[35] = 1;
            byArray[36] = 5;
            byArray[37] = 1;
            byArray[38] = 1;
            byArray[39] = 4;
            byArray[40] = 6;
            byArray[41] = 7;
            byArray[42] = 8;
            byArray[43] = 9;
            byArray[44] = 10;
            byArray[45] = 11;
            byArray[46] = 12;
            byArray[47] = 13;
            byArray[48] = 14;
            byArray[49] = 14;
            byArray[50] = 14;
            byArray[51] = 14;
            byArray[52] = 14;
            byArray[53] = 14;
            byArray[54] = 14;
            byArray[55] = 14;
            byArray[56] = 14;
            byArray[57] = 14;
            byArray[58] = 15;
            byArray[59] = 1;
            byArray[60] = 16;
            byArray[61] = 17;
            byArray[62] = 18;
            byArray[63] = 1;
            byArray[64] = 19;
            byArray[65] = 20;
            byArray[66] = 20;
            byArray[67] = 20;
            byArray[68] = 20;
            byArray[69] = 20;
            byArray[70] = 20;
            byArray[71] = 20;
            byArray[72] = 20;
            byArray[73] = 20;
            byArray[74] = 20;
            byArray[75] = 20;
            byArray[76] = 20;
            byArray[77] = 20;
            byArray[78] = 20;
            byArray[79] = 20;
            byArray[80] = 20;
            byArray[81] = 20;
            byArray[82] = 20;
            byArray[83] = 20;
            byArray[84] = 20;
            byArray[85] = 20;
            byArray[86] = 20;
            byArray[87] = 20;
            byArray[88] = 20;
            byArray[89] = 20;
            byArray[90] = 20;
            byArray[91] = 21;
            byArray[92] = 1;
            byArray[93] = 22;
            byArray[94] = 1;
            byArray[95] = 23;
            byArray[96] = 1;
            byArray[97] = 20;
            byArray[98] = 20;
            byArray[99] = 20;
            byArray[100] = 20;
            byArray[101] = 20;
            byArray[102] = 20;
            byArray[103] = 20;
            byArray[104] = 20;
            byArray[105] = 20;
            byArray[106] = 20;
            byArray[107] = 20;
            byArray[108] = 20;
            byArray[109] = 20;
            byArray[110] = 20;
            byArray[111] = 20;
            byArray[112] = 20;
            byArray[113] = 20;
            byArray[114] = 20;
            byArray[115] = 20;
            byArray[116] = 20;
            byArray[117] = 20;
            byArray[118] = 20;
            byArray[119] = 20;
            byArray[120] = 20;
            byArray[121] = 20;
            byArray[122] = 20;
            byArray[123] = 1;
            byArray[124] = 24;
            byArray[125] = 1;
            byArray[126] = 1;
            byArray[127] = 1;
            fASCIICharMap = byArray;
        }

        public Scanner(StringPool stringPool) {
            this.fStringPool = stringPool;
            this.fAndSymbol = this.fStringPool.addSymbol("and");
            this.fOrSymbol = this.fStringPool.addSymbol("or");
            this.fModSymbol = this.fStringPool.addSymbol("mod");
            this.fDivSymbol = this.fStringPool.addSymbol("div");
            this.fCommentSymbol = this.fStringPool.addSymbol("comment");
            this.fTextSymbol = this.fStringPool.addSymbol("text");
            this.fPISymbol = this.fStringPool.addSymbol("processing-instruction");
            this.fNodeSymbol = this.fStringPool.addSymbol("node");
            this.fAncestorSymbol = this.fStringPool.addSymbol("ancestor");
            this.fAncestorOrSelfSymbol = this.fStringPool.addSymbol("ancestor-or-self");
            this.fAttributeSymbol = this.fStringPool.addSymbol("attribute");
            this.fChildSymbol = this.fStringPool.addSymbol("child");
            this.fDescendantSymbol = this.fStringPool.addSymbol("descendant");
            this.fDescendantOrSelfSymbol = this.fStringPool.addSymbol("descendant-or-self");
            this.fFollowingSymbol = this.fStringPool.addSymbol("following");
            this.fFollowingSiblingSymbol = this.fStringPool.addSymbol("following-sibling");
            this.fNamespaceSymbol = this.fStringPool.addSymbol("namespace");
            this.fParentSymbol = this.fStringPool.addSymbol("parent");
            this.fPrecedingSymbol = this.fStringPool.addSymbol("preceding");
            this.fPrecedingSiblingSymbol = this.fStringPool.addSymbol("preceding-sibling");
            this.fSelfSymbol = this.fStringPool.addSymbol("self");
        }

        protected void addToken(Tokens tokens, int n) throws XPathException {
            tokens.addToken(n);
        }

        public boolean scanExpr(StringPool stringPool, Tokens tokens, String string, int n, int n2) throws XPathException {
            boolean bl = false;
            block23: while (n != n2) {
                int n3;
                int n4;
                int n5;
                int n6 = string.charAt(n);
                while (n6 == 32 || n6 == 10 || n6 == 9 || n6 == 13) {
                    if (++n == n2) break;
                    n6 = string.charAt(n);
                }
                if (n == n2) break;
                int n7 = n6 >= 128 ? 25 : fASCIICharMap[n6];
                switch (n7) {
                    default: {
                        continue block23;
                    }
                    case 6: {
                        this.addToken(tokens, 0);
                        bl = false;
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 7: {
                        this.addToken(tokens, 1);
                        bl = true;
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 21: {
                        this.addToken(tokens, 2);
                        bl = false;
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 22: {
                        this.addToken(tokens, 3);
                        bl = true;
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 12: {
                        if (n + 1 == n2) {
                            this.addToken(tokens, 4);
                            bl = true;
                            ++n;
                            continue block23;
                        }
                        n6 = string.charAt(n + 1);
                        if (n6 == 46) {
                            this.addToken(tokens, 5);
                            bl = true;
                            n += 2;
                        } else if (n6 >= 48 && n6 <= 57) {
                            this.addToken(tokens, 47);
                            bl = true;
                            n = this.scanNumber(tokens, string, n2, n);
                        } else {
                            this.addToken(tokens, 4);
                            bl = true;
                            ++n;
                        }
                        if (n != n2) continue block23;
                        continue block23;
                    }
                    case 19: {
                        this.addToken(tokens, 6);
                        bl = false;
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 10: {
                        this.addToken(tokens, 7);
                        bl = false;
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 15: {
                        if (++n == n2) {
                            return false;
                        }
                        n6 = string.charAt(n);
                        if (n6 != 58) {
                            return false;
                        }
                        this.addToken(tokens, 8);
                        bl = false;
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 13: {
                        if (++n == n2) {
                            this.addToken(tokens, 21);
                            bl = false;
                            continue block23;
                        }
                        n6 = string.charAt(n);
                        if (n6 == 47) {
                            this.addToken(tokens, 22);
                            bl = false;
                            if (++n != n2) continue block23;
                            continue block23;
                        }
                        this.addToken(tokens, 21);
                        bl = false;
                        continue block23;
                    }
                    case 24: {
                        this.addToken(tokens, 23);
                        bl = false;
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 9: {
                        this.addToken(tokens, 24);
                        bl = false;
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 11: {
                        this.addToken(tokens, 25);
                        bl = false;
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 17: {
                        this.addToken(tokens, 26);
                        bl = false;
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 3: {
                        if (++n == n2) {
                            return false;
                        }
                        n6 = string.charAt(n);
                        if (n6 != 61) {
                            return false;
                        }
                        this.addToken(tokens, 27);
                        bl = false;
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 16: {
                        if (++n == n2) {
                            this.addToken(tokens, 28);
                            bl = false;
                            continue block23;
                        }
                        n6 = string.charAt(n);
                        if (n6 == 61) {
                            this.addToken(tokens, 29);
                            bl = false;
                            if (++n != n2) continue block23;
                            continue block23;
                        }
                        this.addToken(tokens, 28);
                        bl = false;
                        continue block23;
                    }
                    case 18: {
                        if (++n == n2) {
                            this.addToken(tokens, 30);
                            bl = false;
                            continue block23;
                        }
                        n6 = string.charAt(n);
                        if (n6 == 61) {
                            this.addToken(tokens, 31);
                            bl = false;
                            if (++n != n2) continue block23;
                            continue block23;
                        }
                        this.addToken(tokens, 30);
                        bl = false;
                        continue block23;
                    }
                    case 4: {
                        int n8 = n6;
                        if (++n == n2) {
                            return false;
                        }
                        n6 = string.charAt(n);
                        int n9 = n;
                        while (n6 != n8) {
                            if (++n == n2) {
                                return false;
                            }
                            n6 = string.charAt(n);
                        }
                        int n10 = n - n9;
                        this.addToken(tokens, 46);
                        bl = true;
                        tokens.addToken(stringPool.addSymbol(string.substring(n9, n9 + n10)));
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 14: {
                        this.addToken(tokens, 47);
                        bl = true;
                        n = this.scanNumber(tokens, string, n2, n);
                        continue block23;
                    }
                    case 5: {
                        if (++n == n2) {
                            return false;
                        }
                        n5 = n;
                        if ((n = this.scanNCName(string, n2, n)) == n5) {
                            return false;
                        }
                        n6 = n < n2 ? (int)string.charAt(n) : -1;
                        n4 = stringPool.addSymbol(string.substring(n5, n));
                        if (n6 != 58) {
                            n3 = -1;
                        } else {
                            n3 = n4;
                            if (++n == n2) {
                                return false;
                            }
                            n5 = n;
                            if ((n = this.scanNCName(string, n2, n)) == n5) {
                                return false;
                            }
                            n6 = n < n2 ? (int)string.charAt(n) : -1;
                            n4 = stringPool.addSymbol(string.substring(n5, n));
                        }
                        this.addToken(tokens, 48);
                        bl = true;
                        tokens.addToken(n3);
                        tokens.addToken(n4);
                        continue block23;
                    }
                    case 8: {
                        if (bl) {
                            this.addToken(tokens, 20);
                            bl = false;
                        } else {
                            this.addToken(tokens, 9);
                            bl = true;
                        }
                        if (++n != n2) continue block23;
                        continue block23;
                    }
                    case 20: 
                    case 23: 
                    case 25: 
                }
                n5 = n;
                n = this.scanNCName(string, n2, n);
                if (n == n5) {
                    return false;
                }
                n6 = n < n2 ? (int)string.charAt(n) : -1;
                n4 = stringPool.addSymbol(string.substring(n5, n));
                boolean bl2 = false;
                boolean bl3 = false;
                n3 = -1;
                if (n6 == 58) {
                    if (++n == n2) {
                        return false;
                    }
                    n6 = string.charAt(n);
                    if (n6 == 42) {
                        if (++n < n2) {
                            n6 = string.charAt(n);
                        }
                        bl2 = true;
                    } else if (n6 == 58) {
                        if (++n < n2) {
                            n6 = string.charAt(n);
                        }
                        bl3 = true;
                    } else {
                        n3 = n4;
                        n5 = n;
                        if ((n = this.scanNCName(string, n2, n)) == n5) {
                            return false;
                        }
                        n6 = n < n2 ? (int)string.charAt(n) : -1;
                        n4 = stringPool.addSymbol(string.substring(n5, n));
                    }
                }
                while (n6 == 32 || n6 == 10 || n6 == 9 || n6 == 13) {
                    if (++n == n2) break;
                    n6 = string.charAt(n);
                }
                if (bl) {
                    if (n4 == this.fAndSymbol) {
                        this.addToken(tokens, 16);
                        bl = false;
                    } else if (n4 == this.fOrSymbol) {
                        this.addToken(tokens, 17);
                        bl = false;
                    } else if (n4 == this.fModSymbol) {
                        this.addToken(tokens, 18);
                        bl = false;
                    } else if (n4 == this.fDivSymbol) {
                        this.addToken(tokens, 19);
                        bl = false;
                    } else {
                        return false;
                    }
                    if (bl2) {
                        return false;
                    }
                    if (!bl3) continue;
                    return false;
                }
                if (n6 == 40 && !bl2 && !bl3) {
                    if (n4 == this.fCommentSymbol) {
                        this.addToken(tokens, 12);
                    } else if (n4 == this.fTextSymbol) {
                        this.addToken(tokens, 13);
                    } else if (n4 == this.fPISymbol) {
                        this.addToken(tokens, 14);
                    } else if (n4 == this.fNodeSymbol) {
                        this.addToken(tokens, 15);
                    } else {
                        this.addToken(tokens, 32);
                        tokens.addToken(n3);
                        tokens.addToken(n4);
                    }
                    this.addToken(tokens, 0);
                    bl = false;
                    if (++n != n2) continue;
                    continue;
                }
                if (bl3 || n6 == 58 && n + 1 < n2 && string.charAt(n + 1) == ':') {
                    if (n4 == this.fAncestorSymbol) {
                        this.addToken(tokens, 33);
                    } else if (n4 == this.fAncestorOrSelfSymbol) {
                        this.addToken(tokens, 34);
                    } else if (n4 == this.fAttributeSymbol) {
                        this.addToken(tokens, 35);
                    } else if (n4 == this.fChildSymbol) {
                        this.addToken(tokens, 36);
                    } else if (n4 == this.fDescendantSymbol) {
                        this.addToken(tokens, 37);
                    } else if (n4 == this.fDescendantOrSelfSymbol) {
                        this.addToken(tokens, 38);
                    } else if (n4 == this.fFollowingSymbol) {
                        this.addToken(tokens, 39);
                    } else if (n4 == this.fFollowingSiblingSymbol) {
                        this.addToken(tokens, 40);
                    } else if (n4 == this.fNamespaceSymbol) {
                        this.addToken(tokens, 41);
                    } else if (n4 == this.fParentSymbol) {
                        this.addToken(tokens, 42);
                    } else if (n4 == this.fPrecedingSymbol) {
                        this.addToken(tokens, 43);
                    } else if (n4 == this.fPrecedingSiblingSymbol) {
                        this.addToken(tokens, 44);
                    } else if (n4 == this.fSelfSymbol) {
                        this.addToken(tokens, 45);
                    } else {
                        return false;
                    }
                    if (bl2) {
                        return false;
                    }
                    this.addToken(tokens, 8);
                    bl = false;
                    if (bl3) continue;
                    ++n;
                    if (++n != n2) continue;
                    continue;
                }
                if (bl2) {
                    this.addToken(tokens, 10);
                    bl = true;
                    tokens.addToken(n4);
                    continue;
                }
                this.addToken(tokens, 11);
                bl = true;
                tokens.addToken(n3);
                tokens.addToken(n4);
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        int scanNCName(String var1_1, int var2_2, int var3_3) {
            var4_4 = var1_1.charAt(var3_3);
            if (!(var4_4 >= '\u0080' ? (XMLCharacterProperties.fgCharFlags[var4_4] & 2) == 0 : (var5_5 = Scanner.fASCIICharMap[var4_4]) != 20 && var5_5 != 23)) ** GOTO lbl-1000
            return var3_3;
            while (!((var4_4 = var1_1.charAt(var3_3)) < '\u0080' ? (var5_5 = Scanner.fASCIICharMap[var4_4]) != 20 && var5_5 != 14 && var5_5 != 12 && var5_5 != 11 && var5_5 != 23 : (XMLCharacterProperties.fgCharFlags[var4_4] & 4) == 0)) lbl-1000:
            // 2 sources

            {
                if (++var3_3 < var2_2) continue;
            }
            return var3_3;
        }

        private int scanNumber(Tokens tokens, String string, int n, int n2) {
            char c = string.charAt(n2);
            int n3 = 0;
            int n4 = 0;
            while (c >= '0' && c <= '9') {
                n3 = n3 * 10 + (c - 48);
                if (++n2 == n) break;
                c = string.charAt(n2);
            }
            if (c == '.' && ++n2 < n) {
                int n5 = n2;
                c = string.charAt(n2);
                while (c >= '0' && c <= '9') {
                    n4 = n4 * 10 + (c - 48);
                    if (++n2 == n) break;
                    c = string.charAt(n2);
                }
                if (n4 != 0) {
                    throw new RuntimeException("find a solution!");
                }
            }
            tokens.addToken(n3);
            tokens.addToken(n4);
            return n2;
        }
    }
}

