/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ComboDef extends ComponentDef {
	private String heightItem;

	private String enable;

	private String tabData;

	private String suggest;

	private List items;

	public Iterator getAllItems() {
		if (items == null)
			return null;
		return items.iterator();
	}

	public void setItems(List items) {
		this.items = items;
	}

	private void addItem(ComboItemDef itemDef) {
		if (items == null)
			items = new ArrayList();
		items.add(itemDef);
	}

	public void addChild(Object comp) {
		super.addChild(comp);
		if (comp instanceof ComboItemDef) {
			addItem((ComboItemDef) comp);
		}
	}

	public String getEnable() {
		return enable;
	}

	public void setEnable(String enable) {
		this.enable = enable;
	}

	public String getHeightItem() {
		return heightItem;
	}

	public void setHeightItem(String heightItem) {
		this.heightItem = heightItem;
	}

	public List getItems() {
		return items;
	}

	public String getSuggest() {
		return suggest;
	}

	public void setSuggest(String suggest) {
		this.suggest = suggest;
	}

	public String getTabData() {
		return tabData;
	}

	public void setTabData(String tabData) {
		this.tabData = tabData;
	}

}
