/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

public class GridDefBeanInfo extends SimpleBeanInfo {
	public PropertyDescriptor[] getPropertyDescriptors() {
		PropertyDescriptor[] descs = null;
		PropertyDescriptor[] gridDefPropDesc = null;
		// GrameDef̐eNXBeanInfo
		try {
			BeanInfo info = Introspector.getBeanInfo(ComponentDef.class);
			descs = info.getPropertyDescriptors();
			gridDefPropDesc = new PropertyDescriptor[] {
					new PropertyDescriptor("lines", GridDef.class, "getLines",
							null),
					new PropertyDescriptor("rang", GridDef.class),
					new PropertyDescriptor("autoResizeParent", GridDef.class),
					new PropertyDescriptor("lineHeight", GridDef.class),
					new PropertyDescriptor("multiSelect", GridDef.class),
					new PropertyDescriptor("actifClic", GridDef.class),
					new PropertyDescriptor("cellActive", GridDef.class),
					new PropertyDescriptor("bNavig", GridDef.class),
					new PropertyDescriptor("boolPrint", GridDef.class),
					new PropertyDescriptor("sortable", GridDef.class),
					new PropertyDescriptor("widthLastCell", GridDef.class),
					new PropertyDescriptor("TabEntete", GridDef.class),
					new PropertyDescriptor("printTitle", GridDef.class),
					new PropertyDescriptor("autoResizeContenu", GridDef.class),
					new PropertyDescriptor("tabTypeCol", GridDef.class),
					new PropertyDescriptor("switchable", GridDef.class),
					new PropertyDescriptor("writable", GridDef.class) };
		} catch (IntrospectionException e) {
			return null;
		}

		// GridDefgPropertyDescriptor[]ǉ
		PropertyDescriptor[] result = new PropertyDescriptor[descs.length
				+ gridDefPropDesc.length];
		System.arraycopy(descs, 0, result, 0, descs.length);
		System.arraycopy(gridDefPropDesc, 0, result, descs.length,
				gridDefPropDesc.length);
		return result;
	}

}
