/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef.customize;

/**
 * Default implementation of <code>IPluginComponentAdapter</code>. Affects
 * five attributes(name,left,top,height,width).
 * 
 * @author shengshen
 */
public class DefaultPluginComponentAdapter implements IPluginComponentAdapter {
	public DefaultPluginComponentAdapter(IPluginComponentDef comp) {
		pluginComponentDef = comp;
	}

	private IPluginComponentDef pluginComponentDef;

	public String getAttribute(String key) {
		if ("name".equals(key)) {
			return pluginComponentDef.getName();
		}
		if ("left".equals(key)) {
			return Integer.toString(pluginComponentDef.getLeft());
		}
		if ("top".equals(key)) {
			return Integer.toString(pluginComponentDef.getTop());
		}
		if ("height".equals(key)) {
			return Integer.toString(pluginComponentDef.getHeight());
		}
		if ("width".equals(key)) {
			return Integer.toString(pluginComponentDef.getWidth());
		}
		return pluginComponentDef.getProxy().getProperty(key);
	}

	public void setAttribute(String key, String value) {
		if ("name".equals(key)) {
			pluginComponentDef.setName(value);
			return;
		}
		if ("left".equals(key)) {
			pluginComponentDef.setLeft(safeToInt(value));
			return;
		}
		if ("top".equals(key)) {
			pluginComponentDef.setTop(safeToInt(value));
			return;
		}
		if ("height".equals(key)) {
			pluginComponentDef.setHeight(safeToInt(value));
			return;
		}
		if ("width".equals(key)) {
			pluginComponentDef.setWidth(safeToInt(value));
			return;
		}
		pluginComponentDef.getProxy().setProperty(key, value);

	}

	private int safeToInt(String value) {
		try {
			return Integer.parseInt(value);
		} catch (NumberFormatException e) {
			return 0;
		}
	}
}
