/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.maskat.framework.IBasicDef;
import org.maskat.framework.IParentAwareDef;
import org.maskat.ide.property.descriptor.ChildPropertyDescriptor;

public class ChildAppendableProperty implements IPropertySource {

	private IBasicDef basicDef;

	private Class addableChildClass;

	private String childTitle;

	public ChildAppendableProperty(IBasicDef event, Class addableChildClass, String childTitle) {
		this.basicDef = event;
		this.addableChildClass = addableChildClass;
		this.childTitle = childTitle;
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		List propDescs = new ArrayList();
		int i = 0;
		for (Iterator it = basicDef.getTypedChildren(addableChildClass); it != null
				&& it.hasNext(); i++) {
			it.next();
			propDescs.add(new ChildPropertyDescriptor(new Integer(i), childTitle));
		}

		return (IPropertyDescriptor[]) propDescs
				.toArray(new IPropertyDescriptor[propDescs.size()]);
	}

	public Object getPropertyValue(Object id) {
		if (id instanceof Integer) {
			int idx = ((Integer) id).intValue();
			return basicDef.getChildByTypeIdx(addableChildClass, idx);
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
	}

	public void addChild(IParentAwareDef child) {
		basicDef.addChild(child);
	}

	public void removeChild(IParentAwareDef child) {
		basicDef.removeChild(child);
	}

	public String toString() {
		return "";
	}
}
