/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.view;

import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.maskat.framework.eventdef.Param;
import org.maskat.framework.eventdef.Result;
import org.maskat.framework.screendef.GridHeaderDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.ide.editors.MaskatEditor;

public class MaskatEditView extends ViewPart implements ISelectionListener {

	Text text = null;

	MaskatEditViewContent vc;

	Composite parent;

	/*
	 * (non-Javadoc) Method declared on IViewPart.
	 */
	public void init(IViewSite site) throws PartInitException {
		site.getPage().addSelectionListener(this);
		super.init(site);
	}

	public void createPartControl(Composite parent) {
		this.parent = parent;
		vc = new MaskatEditViewContent();
		vc.createPartControl(parent);
	}

	public void showParam(Param param, MaskatEditor ep) {
		if (vc != null)
			vc.showParam(parent, param, (CommandStack) ep.getAdapter(CommandStack.class));
		parent.layout();
	}

	public void showResult(Result result, MaskatEditor ep) {
		if (vc != null)
			vc.showResult(parent, result, (CommandStack) ep
					.getAdapter(CommandStack.class));
		parent.layout();
	}

	public void setFocus() {
		parent.forceFocus();
	}

	/**
	 * selectionChangedł͂ȂAڃf[^̃r[ɓC^tF[X
	 * 
	 * @param data
	 */
	public void acceptData(String data) {
		vc.acceptData(data);
	}

	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if (vc == null || vc.isBlankState()) {
			return;
		}
		if (part instanceof MaskatEditor) {
			MaskatEditor maskatEditor = (MaskatEditor) part;

			if (maskatEditor.gettingFocus) {
				maskatEditor.gettingFocus = false;
				return;// selection event will come again. ignore the first
				// time.
			}

			if (maskatEditor.editMode != MaskatEditor.SCREEN_EDIT_MODE) {
				// source܂paramedit modeAselectionʏɔfB
				if (!selection.isEmpty()) {
					if (selection instanceof StructuredSelection) {
						StructuredSelection ss = (StructuredSelection) selection;
						if (ss.getFirstElement() instanceof AbstractGraphicalEditPart) {
							AbstractGraphicalEditPart ssG = (AbstractGraphicalEditPart) ss
									.getFirstElement();
							// if (ssG instanceof ComponentEditPart) {
							// Figure parent = ((ComponentEditPart) ssG)
							// .getLabel();
							// for (Iterator it = parent.getChildren()
							// .iterator(); it.hasNext();) {
							// ((Figure) it.next()).setVisible(false);
							// }
							// }
							Object model = ssG.getModel();
							if (model instanceof IComponentDef) {
								IComponentDef cm = (IComponentDef) model;
								vc.acceptData(cm.getName());
								// text.append(cm.getName() + "\n");
							}
							if (model instanceof GridHeaderDef) {
								GridHeaderDef gh = (GridHeaderDef) model;
								vc.acceptData(String.valueOf(gh.idxInParent()));
							}
						}
					}
				}
			}
		}
	}

}
