/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.jaxp.DefaultValidationErrorHandler;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentBuilderImpl
extends DocumentBuilder {
    static final String XERCES_FEATURE_PREFIX = "http://apache.org/xml/features/";
    static final String CREATE_ENTITY_REF_NODES_FEATURE = "dom/create-entity-ref-nodes";
    static final String INCLUDE_IGNORABLE_WHITESPACE = "dom/include-ignorable-whitespace";
    private DocumentBuilderFactory dbf;
    private EntityResolver er = null;
    private ErrorHandler eh = null;
    private DOMParser domParser = null;
    private boolean namespaceAware = false;
    private boolean validating = false;

    DocumentBuilderImpl(DocumentBuilderFactory documentBuilderFactory) throws ParserConfigurationException {
        this.dbf = documentBuilderFactory;
        this.domParser = new DOMParser();
        try {
            this.validating = documentBuilderFactory.isValidating();
            String string = "http://xml.org/sax/features/validation";
            this.domParser.setFeature(string, this.validating);
            if (this.validating) {
                this.setErrorHandler(new DefaultValidationErrorHandler());
            }
            this.namespaceAware = documentBuilderFactory.isNamespaceAware();
            this.domParser.setFeature("http://xml.org/sax/features/namespaces", this.namespaceAware);
            this.domParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", documentBuilderFactory.isIgnoringElementContentWhitespace() ^ true);
            this.domParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", documentBuilderFactory.isExpandEntityReferences() ^ true);
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(sAXException.getMessage());
        }
    }

    public DOMImplementation getDOMImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public Document newDocument() {
        return new DocumentImpl();
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        if (this.er != null) {
            this.domParser.setEntityResolver(this.er);
        }
        if (this.eh != null) {
            this.domParser.setErrorHandler(this.eh);
        }
        this.domParser.parse(inputSource);
        return this.domParser.getDocument();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.er = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler == null ? new DefaultHandler() : errorHandler;
    }
}

