/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.framework.screendef;

import java.util.HashMap;
import java.util.Iterator;
import org.maskat.framework.IBasicDefVisitor;
import org.maskat.framework.eventdef.IEventDefSource;
import org.maskat.framework.screendef.ContainerDef;
import org.maskat.framework.screendef.IContainerDef;
import org.maskat.framework.screendef.MaskatDef;
import org.maskat.framework.screendef.RadioDef;
import org.maskat.framework.screendef.RadioGroupDef;
import org.maskat.framework.screendef.RadioMemberDef;

public class LayoutDef
extends ContainerDef {
    private String objs = "";
    private String refParentHTML;
    private IEventDefSource layoutEvtDefSrc;
    private MaskatDef maskatDef;

    public IEventDefSource getLayoutEvtDefSrc() {
        return this.layoutEvtDefSrc;
    }

    public void setLayoutEvtDefSrc(IEventDefSource layoutEvtDefSrc) {
        this.layoutEvtDefSrc = layoutEvtDefSrc;
    }

    public IContainerDef getLayoutDef() {
        return this;
    }

    public String getRefParentHTML() {
        return this.refParentHTML;
    }

    public void setRefParentHTML(String refParentHTML) {
        this.refParentHTML = refParentHTML;
    }

    public MaskatDef getMaskatDef() {
        return this.maskatDef;
    }

    public void setMaskatDef(MaskatDef maskatDef) {
        this.maskatDef = maskatDef;
    }

    public String getObjs() {
        return this.objs;
    }

    public void addObjs(String objs) {
        this.objs = String.valueOf(this.objs) + objs + ",";
    }

    public void unpackRadioGroup() {
        Iterator it = this.getTypedChildren(RadioGroupDef.class);
        if (it == null) {
            return;
        }
        final HashMap<String, String> nameToGroupMap = new HashMap<String, String>();
        while (it.hasNext()) {
            RadioGroupDef rg = (RadioGroupDef)it.next();
            String groupName = rg.getName();
            Iterator memberIt = rg.getTypedChildren(RadioMemberDef.class);
            while (memberIt != null && memberIt.hasNext()) {
                RadioMemberDef member = (RadioMemberDef)memberIt.next();
                if (member.getRef() == null) continue;
                nameToGroupMap.put(member.getRef(), groupName);
            }
        }
        if (nameToGroupMap.size() > 0) {
            this.accept(new IBasicDefVisitor(){

                public void visit(Object def) {
                    if (def instanceof RadioDef) {
                        RadioDef radioDef = (RadioDef)def;
                        radioDef.setGroup((String)nameToGroupMap.get(radioDef.getName()));
                    }
                }
            });
        }
        this.removeAllByType(RadioGroupDef.class);
    }

    public void packRadioGroup() {
        this.removeAllByType(RadioGroupDef.class);
        final HashMap radioGroupMap = new HashMap();
        this.accept(new IBasicDefVisitor(){

            public void visit(Object def) {
                if (def instanceof RadioDef) {
                    RadioDef radioDef = (RadioDef)def;
                    String group = radioDef.getGroup();
                    if (group == null || "".equals(group)) {
                        return;
                    }
                    RadioGroupDef radioGroup = (RadioGroupDef)radioGroupMap.get(group);
                    if (radioGroup == null) {
                        radioGroup = new RadioGroupDef();
                        radioGroup.setName(group);
                        radioGroupMap.put(group, radioGroup);
                    }
                    radioGroup.addMember(radioDef.getName());
                }
            }
        });
        if (radioGroupMap.values() != null) {
            Iterator it = radioGroupMap.values().iterator();
            while (it.hasNext()) {
                this.addChildToIdx(it.next(), 0);
            }
        }
    }
}

