/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.gef.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.maskat.framework.screendef.DivSplitDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.IContainerDef;

public class ChangeConstraintCommand
extends Command {
    private IComponentDef nodeElement;
    private Rectangle newConstraint;
    private Rectangle oldConstraint;

    public ChangeConstraintCommand(IComponentDef node) {
        super(String.valueOf(node.getName()) + "\u306e\u4f4d\u7f6e\u3001\u30b5\u30a4\u30ba\u5909\u66f4");
        this.nodeElement = node;
    }

    public void execute() {
        if (this.nodeElement instanceof DivSplitDef) {
            int deltaX = this.newConstraint.x - this.nodeElement.getLeft();
            int deltaY = this.newConstraint.y - this.nodeElement.getTop();
            int deltaWidth = this.newConstraint.width - this.nodeElement.getWidth();
            int deltaHeight = this.newConstraint.height - this.nodeElement.getHeight();
            IContainerDef parent = this.nodeElement.getParent();
            this.oldConstraint = new Rectangle(parent.getLeft(), parent.getTop(), parent.getWidth(), parent.getHeight());
            parent.setConstraint(parent.getLeft() + deltaX, parent.getTop() + deltaY, parent.getWidth() + deltaWidth, parent.getHeight() + deltaHeight);
        } else {
            this.oldConstraint = new Rectangle(this.nodeElement.getLeft(), this.nodeElement.getTop(), this.nodeElement.getWidth(), this.nodeElement.getHeight());
            this.nodeElement.setConstraint(this.newConstraint.x, this.newConstraint.y, this.newConstraint.width, this.newConstraint.height);
        }
    }

    public void setConstraint(Rectangle rect) {
        this.newConstraint = rect;
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.nodeElement instanceof DivSplitDef) {
            this.nodeElement.getParent().setConstraint(this.oldConstraint.x, this.oldConstraint.y, this.oldConstraint.width, this.oldConstraint.height);
        } else {
            this.nodeElement.setConstraint(this.oldConstraint.x, this.oldConstraint.y, this.oldConstraint.width, this.oldConstraint.height);
        }
    }
}

