/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.property;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.maskat.ide.property.AbstractMaskatPropertySource;

public class ConstraintProperty
extends AbstractMaskatPropertySource {
    public static final int METRIC_ALL = 0;
    public static final int METRIC_XY = 1;
    public static final int METRIC_XYWIDTH = 2;
    public static final int METRIC_XYHEIGHT = 4;
    private static String PROP_X = "_prop_x_";
    private static String PROP_Y = "_prop_y_";
    private static String PROP_WIDTH = "_prop_width_";
    private static String PROP_HEIGHT = "_prop_height_";
    private static IPropertyDescriptor X = new TextPropertyDescriptor((Object)PROP_X, "left");
    private static IPropertyDescriptor Y = new TextPropertyDescriptor((Object)PROP_Y, "top");
    private static IPropertyDescriptor WIDTH = new TextPropertyDescriptor((Object)PROP_WIDTH, "width");
    private static IPropertyDescriptor HEIGHT = new TextPropertyDescriptor((Object)PROP_HEIGHT, "height");
    private static final IPropertyDescriptor[] METRIC_PROPDESC_ALL = new IPropertyDescriptor[]{X, Y, WIDTH, HEIGHT};
    private static final IPropertyDescriptor[] METRIC_PROPDESC_XY = new IPropertyDescriptor[]{X, Y};
    private static final IPropertyDescriptor[] METRIC_PROPDESC_XYWIDTH = new IPropertyDescriptor[]{X, Y, WIDTH};
    private static final IPropertyDescriptor[] METRIC_PROPDESC_XYHEIGHT = new IPropertyDescriptor[]{X, Y, HEIGHT};
    private Rectangle rect;
    private IPropertyDescriptor[] descriptors = null;

    static {
        int i = 0;
        while (i < METRIC_PROPDESC_ALL.length) {
            ((TextPropertyDescriptor)METRIC_PROPDESC_ALL[i]).setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    try {
                        Integer.parseInt((String)value);
                        return null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "\u6570\u5b57\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                    }
                }
            });
            ++i;
        }
    }

    public ConstraintProperty(Rectangle constraint, int metricType) {
        this.rect = constraint;
        if (metricType == 0) {
            this.descriptors = METRIC_PROPDESC_ALL;
        }
        if (metricType == 1) {
            this.descriptors = METRIC_PROPDESC_XY;
        }
        if (metricType == 4) {
            this.descriptors = METRIC_PROPDESC_XYHEIGHT;
        }
        if (metricType == 2) {
            this.descriptors = METRIC_PROPDESC_XYWIDTH;
        }
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors != null) {
            return this.descriptors;
        }
        return METRIC_PROPDESC_ALL;
    }

    public Object doGetPropertyValue(Object id) {
        if (PROP_X.equals(id)) {
            return Integer.toString(this.rect.x);
        }
        if (PROP_Y.equals(id)) {
            return Integer.toString(this.rect.y);
        }
        if (PROP_WIDTH.equals(id)) {
            return Integer.toString(this.rect.width);
        }
        if (PROP_HEIGHT.equals(id)) {
            return Integer.toString(this.rect.height);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void doSetPropertyValue(Object id, Object value) {
        if (id.equals(PROP_X)) {
            this.rect.x = Integer.parseInt((String)value);
        }
        if (id.equals(PROP_Y)) {
            this.rect.y = Integer.parseInt((String)value);
        }
        if (PROP_WIDTH.equals(id)) {
            this.rect.width = Integer.parseInt((String)value);
        }
        if (PROP_HEIGHT.equals(id)) {
            this.rect.height = Integer.parseInt((String)value);
        }
    }

    public String toString() {
        return "";
    }

    public Rectangle getRect() {
        return this.rect;
    }
}

