/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.wizards;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.maskat.ide.wizards.HtmlContainerParam;
import org.maskat.ide.wizards.MaskatHtmlContainerNewWizardPage;

public class MaskatHtmlContainerNewWizard
extends Wizard
implements INewWizard {
    private MaskatHtmlContainerNewWizardPage page;
    private ISelection selection;
    private static String containerTemplate = null;

    public MaskatHtmlContainerNewWizard() {
        this.setWindowTitle("Maskat Container HTML Wizard");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new MaskatHtmlContainerNewWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        final HtmlContainerParam param = new HtmlContainerParam();
        param.setLayoutFileName(this.page.getLayoutFileName());
        param.setEventFileName(this.page.getEventFileName());
        param.setTitle(this.page.getHTMLTitle());
        param.setMaskatFWPath(this.page.getFWPath());
        param.setHeight(this.page.getDivHeight());
        param.setWidth(this.page.getDivWidth());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        MaskatHtmlContainerNewWizard.this.doFinish(containerName, fileName, param, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, HtmlContainerParam param, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream(param);
            if (file.exists()) {
                this.throwCoreException("File already exists. Choose another name.");
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private String getTemplate() throws IOException {
        if (containerTemplate == null) {
            containerTemplate = "";
            InputStream stream = null;
            try {
                stream = ((Object)((Object)this)).getClass().getResourceAsStream("containerHtmlTemplate.template");
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    containerTemplate = String.valueOf(containerTemplate) + line + System.getProperty("line.separator");
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        return containerTemplate;
    }

    private InputStream openContentStream(HtmlContainerParam param) throws IOException {
        String contents = this.getTemplate().replaceAll("<\\$title\\$>", param.getTitle()).replaceAll("<\\$maskatFWPath\\$>", param.getMaskatFWPath()).replaceAll("<\\$layoutFileName\\$>", param.getLayoutFileName()).replaceAll("<\\$eventFileName\\$>", param.getEventFileName()).replaceAll("<\\$containerWidth\\$>", String.valueOf(param.getWidth())).replaceAll("<\\$containerHeight\\$>", String.valueOf(param.getHeight()));
        return new ByteArrayInputStream(contents.getBytes("UTF-8"));
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.maskat.ide.gef", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

