/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.gef.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.IContainerDef;
import org.maskat.framework.screendef.LayoutDef;
import org.maskat.framework.screendef.MaskatDef;
import org.maskat.framework.screendef.PopupDef;
import org.maskat.framework.screendef.customize.IPluginComponentDef;

public class AddComponentCommand
extends Command {
    private IContainerDef parent;
    private IComponentDef node;
    private Rectangle constraint;
    private boolean shouldUndoNamespace;

    public AddComponentCommand(IContainerDef parent, IComponentDef node) {
        this.parent = parent;
        this.node = node;
    }

    public void setConstraint(Rectangle rectangle) {
        this.constraint = rectangle;
    }

    public void execute() {
        int targetY = this.constraint.y;
        if (this.parent instanceof PopupDef) {
            targetY -= 20;
            targetY = Math.max(0, targetY);
        }
        if (this.constraint.width == -1 && this.constraint.height == -1) {
            this.node.setLeft(this.constraint.x);
            this.node.setTop(targetY);
        } else {
            this.node.setConstraint(this.constraint.x, targetY, this.constraint.width, this.constraint.height);
        }
        LayoutDef layoutDef = this.parent.getLayoutDef();
        MaskatDef md = layoutDef.getMaskatDef();
        if (this.node instanceof IPluginComponentDef) {
            IPluginComponentDef pluginCompDef = (IPluginComponentDef)this.node;
            String prefix = pluginCompDef.getProxy().getPrefix();
            String namespace = pluginCompDef.getProxy().getNamespace();
            if (namespace == null || "".equals(namespace)) {
                this.shouldUndoNamespace = false;
            } else if (md.getNamespaces().containsKey(namespace)) {
                this.shouldUndoNamespace = false;
                pluginCompDef.getProxy().setPrefix((String)md.getNamespaces().get(namespace));
            } else {
                this.shouldUndoNamespace = true;
                md.getNamespaces().put(namespace, prefix);
            }
        }
        this.parent.addChild(this.node);
    }

    public void undo() {
        this.parent.removeChild(this.node);
        if (this.shouldUndoNamespace && this.node instanceof IPluginComponentDef) {
            LayoutDef layoutDef = this.parent.getLayoutDef();
            MaskatDef md = layoutDef.getMaskatDef();
            IPluginComponentDef pluginCompDef = (IPluginComponentDef)this.node;
            md.getNamespaces().remove(pluginCompDef.getProxy().getNamespace());
        }
    }

    public boolean canUndo() {
        return true;
    }
}

