/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.property.descriptor;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.ide.property.EventProperty;

public class EventPropertyDescriptor
extends PropertyDescriptor {
    public static final String EVENT_ON_DISP = "on";
    public static final String EVENT_OFF_DISP = "off";

    public EventPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        ComboCellEditor editor = new ComboCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    private class ComboCellEditor
    extends CellEditor {
        private CCombo combo;
        private Object value;

        public ComboCellEditor(Composite parent) {
            super(parent, 0);
            this.combo.add(EventPropertyDescriptor.EVENT_OFF_DISP);
            this.combo.add(EventPropertyDescriptor.EVENT_ON_DISP);
        }

        protected Control createControl(Composite parent) {
            this.combo = new CCombo(parent, 8);
            this.combo.addFocusListener((FocusListener)new FocusAdapter(this){
                final /* synthetic */ ComboCellEditor this$1;
                {
                    this.this$1 = comboCellEditor;
                }

                public void focusLost(FocusEvent e) {
                    if (this.this$1.isActivated()) {
                        String newValue = ComboCellEditor.access$0(this.this$1).getText();
                        ComboCellEditor.access$1(this.this$1, newValue);
                    }
                }
            });
            this.combo.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ ComboCellEditor this$1;
                {
                    this.this$1 = comboCellEditor;
                }

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        ComboCellEditor.access$2(this.this$1);
                    }
                }
            });
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ComboCellEditor this$1;
                {
                    this.this$1 = comboCellEditor;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    String newValue = ComboCellEditor.access$0(this.this$1).getText();
                    ComboCellEditor.access$1(this.this$1, newValue);
                }
            });
            return this.combo;
        }

        private void updateValue(Object newValue) {
            if (newValue != null) {
                boolean newValidState = this.isCorrect(newValue);
                if (newValidState) {
                    this.markDirty();
                    this.doSetValue(newValue);
                } else {
                    this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newValue.toString()));
                }
                this.fireApplyEditorValue();
                this.deactivate();
            }
        }

        protected Object doGetValue() {
            return this.value;
        }

        protected void doSetFocus() {
            this.combo.setFocus();
        }

        protected void doSetValue(Object value) {
            this.value = value;
            if (value instanceof String) {
                this.combo.setText((String)value);
            }
            if (value instanceof EventProperty) {
                EventProperty ep = (EventProperty)value;
                if (ep.isEnable()) {
                    this.combo.setText(EventPropertyDescriptor.EVENT_ON_DISP);
                } else {
                    this.combo.setText(EventPropertyDescriptor.EVENT_OFF_DISP);
                }
            }
        }

        static /* synthetic */ CCombo access$0(ComboCellEditor comboCellEditor) {
            return comboCellEditor.combo;
        }

        static /* synthetic */ void access$1(ComboCellEditor comboCellEditor, Object object) {
            comboCellEditor.updateValue(object);
        }

        static /* synthetic */ void access$2(ComboCellEditor comboCellEditor) {
            comboCellEditor.fireCancelEditor();
        }
    }
}

