/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.tabbedproperties;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Text;
import org.maskat.ide.editors.MaskatEditor;

public class TextValueWatcher
implements FocusListener {
    private String oldValue;
    private Object beanObj;
    private String prop;
    protected Text text;
    protected MaskatEditor editor;

    public TextValueWatcher(Text text, Object obj, String prop, MaskatEditor editor) {
        this.text = text;
        this.beanObj = obj;
        this.prop = prop;
        this.editor = editor;
    }

    public void focusGained(FocusEvent e) {
        this.oldValue = this.text.getText();
    }

    public void focusLost(FocusEvent e) {
        String newValue = this.text.getText();
        if (!this.oldValue.equals(newValue)) {
            if ("".equals(newValue)) {
                newValue = null;
            }
            try {
                PropertyUtils.setProperty((Object)this.beanObj, (String)this.prop, (Object)newValue);
                this.editor.makeDirty();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
    }
}

