/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.maskat.framework.eventdef.Param;
import org.maskat.framework.eventdef.Result;
import org.maskat.framework.eventdef.Source;
import org.maskat.framework.eventdef.Target;
import org.maskat.ide.editors.MaskatEditor;
import org.maskat.ide.property.SourceProperty;
import org.maskat.ide.property.TargetProperty;
import org.maskat.ide.view.MaskatEditView;
import org.maskat.ide.view.SetChildrenCommand;
import org.maskat.ide.view.edit.AbstractNavigateFiller;
import org.maskat.ide.view.edit.BindNavigateFiller;
import org.maskat.ide.view.edit.DefaultNavigateFiller;
import org.maskat.ide.view.edit.ResultNavigateFiller;
import org.maskat.ide.view.edit.TableKeyListener;
import org.maskat.xml.xmlbeans.EventSchemaUtil;

public class MaskatEditViewContent {
    private Group resultGroup;
    private Group bindGroup;
    private Group paramGroup;
    private Group buttonGroup;
    private Table resultTable;
    private Table bindTable;
    private Table paramTable;
    private AbstractNavigateFiller resultFiller;
    private AbstractNavigateFiller bindFiller;
    private AbstractNavigateFiller paramFiller;
    private AbstractNavigateFiller resultNodeNameFiller;
    private AbstractNavigateFiller paramNodeNameFiller;
    private Button okBtn;
    private Button cancelBtn;
    private Button maruBtn;
    private Button batuBtn;
    private Button openSchemaFileBtn;
    private org.eclipse.swt.widgets.List nodeNameList;
    private static final int BLANK_STATE = 0;
    private static final int PARAM_STATE = 1;
    private static final int RESULT_STATE = 2;
    private static final int PARAM_BIND_STATE = 5;
    private static final int RESULT_BIND_STATE = 6;
    private Param param;
    private Result result;
    private String eventType;
    private int currentState = 0;
    private CommandStack cs;
    private MaskatEditView theView;

    public CommandStack getCS() {
        return this.cs;
    }

    public boolean isBlankState() {
        return this.currentState == 0;
    }

    public MaskatEditView getTheView() {
        return this.theView;
    }

    public void setTheView(MaskatEditView theView) {
        this.theView = theView;
    }

    private void uiSwitchState(int newState) {
        if (newState == 0) {
            this.okBtn.setEnabled(false);
            this.cancelBtn.setEnabled(false);
            this.maruBtn.setEnabled(false);
            this.batuBtn.setEnabled(false);
        }
        if (newState == 1 || newState == 2) {
            if (newState == 1) {
                this.paramTable.setEnabled(true);
            } else {
                this.resultTable.setEnabled(true);
            }
            this.okBtn.setEnabled(true);
            this.cancelBtn.setEnabled(true);
            this.maruBtn.setEnabled(false);
            this.batuBtn.setEnabled(false);
        }
        if (newState == 5 || newState == 6) {
            if (newState == 5) {
                this.paramTable.setEnabled(false);
            } else {
                this.resultTable.setEnabled(false);
            }
            this.okBtn.setEnabled(false);
            this.cancelBtn.setEnabled(false);
            this.maruBtn.setEnabled(true);
            this.batuBtn.setEnabled(true);
        }
        this.currentState = newState;
    }

    private void uiSwitchOffBindState() {
        if (this.currentState == 5) {
            this.uiSwitchState(1);
        }
        if (this.currentState == 6) {
            this.uiSwitchState(2);
        }
    }

    private void disposeAll() {
        this.dispose((Composite)this.paramTable);
        this.paramTable = null;
        this.dispose((Composite)this.resultTable);
        this.resultTable = null;
        this.dispose((Composite)this.bindTable);
        this.bindTable = null;
        this.dispose((Composite)this.paramGroup);
        this.paramGroup = null;
        this.dispose((Composite)this.resultGroup);
        this.resultGroup = null;
        this.dispose((Composite)this.bindGroup);
        this.bindGroup = null;
        this.dispose((Composite)this.buttonGroup);
        this.buttonGroup = null;
    }

    private void dispose(Composite comp) {
        if (comp != null) {
            comp.dispose();
        }
    }

    public boolean showParam(Composite parent, Param param, CommandStack cs) {
        this.disposeAll();
        GridLayout gridLayout = new GridLayout(4, false);
        parent.setLayout((Layout)gridLayout);
        this.createParamGroup(parent);
        this.createParamTable((Composite)this.paramGroup);
        this.createBindGroup(parent);
        this.createBindTable((Composite)this.bindGroup);
        if (param != null) {
            Iterator it = param.getSourcesIt();
            while (it != null && it.hasNext()) {
                Source source = (Source)it.next();
                TableItem item = new TableItem(this.paramTable, 0);
                if (source.getObj() != null) {
                    item.setText(0, source.getObj());
                }
                if (source.getNode() != null) {
                    item.setText(1, source.getNode());
                }
                if (source.getChildNode() != null) {
                    item.setText(2, source.getChildNode());
                }
                if (source.getIdxRef() != null) {
                    item.setText(3, source.getIdxRef());
                }
                item.setData((Object)source.getAllChildren());
            }
            this.param = param;
            this.eventType = param.getEventType();
        }
        this.paramFiller.resetIndex();
        this.createButtonGroup(parent);
        this.uiSwitchState(1);
        if (this.cs == cs) {
            return false;
        }
        this.cs = cs;
        return true;
    }

    public boolean showResult(Composite parent, Result result, CommandStack cs) {
        this.disposeAll();
        GridLayout gridLayout = new GridLayout(4, false);
        parent.setLayout((Layout)gridLayout);
        this.createResultGroup(parent);
        this.createResultTable((Composite)this.resultGroup);
        this.createBindGroup(parent);
        this.createBindTable((Composite)this.bindGroup);
        if (result != null) {
            Iterator it = result.getTargetsIt();
            while (it != null && it.hasNext()) {
                Target target = (Target)it.next();
                TableItem item = new TableItem(this.resultTable, 0);
                if (target.getOut() != null) {
                    item.setText(0, target.getOut());
                }
                if (target.getIn() != null) {
                    item.setText(1, target.getIn());
                }
                if (target.getInkey() != null) {
                    item.setText(2, target.getInkey());
                }
                if (target.getType() != null) {
                    item.setText(3, target.getType());
                }
                item.setData((Object)target.getBinds());
            }
            this.result = result;
            this.eventType = result.getEventType();
        }
        this.resultFiller.resetIndex();
        this.createButtonGroup(parent);
        this.uiSwitchState(2);
        if (this.cs == cs) {
            return false;
        }
        this.cs = cs;
        return true;
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout(3, false);
        parent.setLayout((Layout)gridLayout);
    }

    private void createParamGroup(Composite parent) {
        this.paramGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.paramGroup.setLayout((Layout)layout);
        this.paramGroup.setText("param");
        GridData data = new GridData(1808);
        this.paramGroup.setLayoutData((Object)data);
    }

    private void createBindGroup(Composite parent) {
        this.bindGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.bindGroup.setLayout((Layout)layout);
        this.bindGroup.setText("bind");
        GridData data = new GridData(1808);
        this.bindGroup.setLayoutData((Object)data);
    }

    private void createResultGroup(Composite parent) {
        this.resultGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.resultGroup.setLayout((Layout)layout);
        this.resultGroup.setText("result");
        GridData data = new GridData(1808);
        this.resultGroup.setLayoutData((Object)data);
    }

    private void createButtonGroup(Composite parent) {
        this.buttonGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.buttonGroup.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.buttonGroup.setLayoutData((Object)data);
        this.okBtn = new Button((Composite)this.buttonGroup, 8);
        this.okBtn.setText("OK");
        this.okBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaskatEditor ep = MaskatEditViewContent.this.theView.getEditTarget();
                if (MaskatEditViewContent.this.currentState == 1) {
                    MaskatEditViewContent.this.syncDataToParam();
                }
                if (MaskatEditViewContent.this.currentState == 2) {
                    MaskatEditViewContent.this.syncDataToResult();
                }
                ep.editMode = 1;
                MaskatEditViewContent.this.uiSwitchState(0);
                MaskatEditViewContent.this.resetContent();
            }
        });
        this.cancelBtn = new Button((Composite)this.buttonGroup, 8);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaskatEditor ep = MaskatEditViewContent.this.theView.getEditTarget();
                ep.editMode = 1;
                MaskatEditViewContent.this.uiSwitchState(0);
                MaskatEditViewContent.this.resetContent();
            }
        });
        this.maruBtn = new Button((Composite)this.buttonGroup, 8);
        this.maruBtn.setText("\u25cb");
        this.maruBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaskatEditViewContent.this.uiSwitchOffBindState();
            }
        });
        this.batuBtn = new Button((Composite)this.buttonGroup, 8);
        this.batuBtn.setText("\u00d7");
        this.batuBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaskatEditViewContent.this.uiSwitchOffBindState();
            }
        });
        this.nodeNameList = new org.eclipse.swt.widgets.List((Composite)this.buttonGroup, 2818);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.nodeNameList.setLayoutData((Object)gridData);
        this.nodeNameList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String value = MaskatEditViewContent.this.nodeNameList.getItem(MaskatEditViewContent.this.nodeNameList.getSelectionIndex());
                MaskatEditViewContent.this.fillNodeName(value);
            }
        });
        this.nodeNameList.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.keyCode == 13) {
                    String[] values = MaskatEditViewContent.this.nodeNameList.getSelection();
                    int i = 0;
                    while (i < values.length) {
                        MaskatEditViewContent.this.fillNodeName(values[i]);
                        ++i;
                    }
                }
            }
        });
        this.openSchemaFileBtn = new Button((Composite)this.buttonGroup, 8);
        this.openSchemaFileBtn.setText("Open Schema");
        final FileDialog dialog = new FileDialog(this.buttonGroup.getShell(), 4);
        this.openSchemaFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fileName = dialog.open();
                try {
                    if (fileName == null) {
                        return;
                    }
                    List nodeNames = EventSchemaUtil.scanAllNodeName(new FileInputStream(new File(fileName)));
                    MaskatEditViewContent.this.nodeNameList.removeAll();
                    MaskatEditViewContent.this.nodeNameList.setItems(nodeNames.toArray(new String[nodeNames.size()]));
                    MaskatEditViewContent.this.buttonGroup.layout();
                }
                catch (XmlException e1) {
                    MessageDialog.openError((Shell)MaskatEditViewContent.this.buttonGroup.getShell(), (String)"XML\u89e3\u6790\u5931\u6557\uff01", (String)("\u6b63\u78ba\u30b9\u30ad\u30fc\u30de\u30d5\u30a1\u30a4\u30eb\u3067\u3042\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\u30a8\u30e9\u30fc\uff1a" + e1.getMessage()));
                }
                catch (IOException e1) {
                    MessageDialog.openError((Shell)MaskatEditViewContent.this.buttonGroup.getShell(), (String)"\u30b9\u30ad\u30fc\u30de\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u5931\u6557\uff01", (String)("\u30a8\u30e9\u30fc\uff1a" + e1.getMessage()));
                }
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.openSchemaFileBtn.setLayoutData((Object)gridData);
    }

    private void resetContent() {
        this.theView.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(new Object()));
    }

    private void fillNodeName(String value) {
        if (this.currentState == 1) {
            this.paramNodeNameFiller.acceptString(value);
        }
        if (this.currentState == 2) {
            this.resultNodeNameFiller.acceptString(value);
        }
        if (this.currentState == 5 || this.currentState == 6) {
            this.bindFiller.acceptString(value);
        }
    }

    private void createParamTable(Composite parent) {
        this.paramTable = new Table(parent, 68100);
        GridData gd = new GridData(1808);
        this.paramTable.setLayoutData((Object)gd);
        TableColumn tableColumn = new TableColumn(this.paramTable, 0);
        tableColumn.setText("obj");
        tableColumn.setWidth(90);
        tableColumn = new TableColumn(this.paramTable, 0);
        tableColumn.setText("node");
        tableColumn.setWidth(90);
        tableColumn = new TableColumn(this.paramTable, 0);
        tableColumn.setText("childNode");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.paramTable, 0);
        tableColumn.setText("idxRef");
        tableColumn.setWidth(60);
        this.paramTable.setHeaderVisible(true);
        this.paramFiller = new DefaultNavigateFiller(this.paramTable);
        this.paramNodeNameFiller = new DefaultNavigateFiller(this.paramTable);
        ((DefaultNavigateFiller)this.paramNodeNameFiller).targetColumn = 1;
        TableKeyListener.bindTableKeyListener(this.paramTable);
        this.paramTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MaskatEditViewContent.this.uiSwitchState(5);
            }
        });
    }

    private void createResultTable(Composite parent) {
        this.resultTable = new Table(parent, 68100);
        GridData gd = new GridData(1808);
        this.resultTable.setLayoutData((Object)gd);
        TableColumn tableColumn = new TableColumn(this.resultTable, 0);
        tableColumn.setText("out");
        tableColumn.setWidth(90);
        tableColumn = new TableColumn(this.resultTable, 0);
        tableColumn.setText("in");
        tableColumn.setWidth(90);
        tableColumn = new TableColumn(this.resultTable, 0);
        tableColumn.setText("inkey");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.resultTable, 0);
        tableColumn.setText("type");
        tableColumn.setWidth(60);
        this.resultTable.setHeaderVisible(true);
        this.resultFiller = new ResultNavigateFiller(this.resultTable);
        this.resultNodeNameFiller = new DefaultNavigateFiller(this.resultTable);
        ((DefaultNavigateFiller)this.resultNodeNameFiller).targetColumn = 1;
        TableKeyListener.bindTableKeyListener(this.resultTable);
        this.resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MaskatEditViewContent.this.uiSwitchState(6);
            }
        });
    }

    private void createBindTable(Composite parent) {
        this.bindTable = new Table(parent, 68100);
        GridData gd = new GridData(1808);
        this.bindTable.setLayoutData((Object)gd);
        TableColumn tableColumn = new TableColumn(this.bindTable, 0);
        tableColumn.setText("fromkey");
        tableColumn.setWidth(60);
        tableColumn = new TableColumn(this.bindTable, 0);
        tableColumn.setText("tokey");
        tableColumn.setWidth(60);
        tableColumn = new TableColumn(this.bindTable, 0);
        tableColumn.setText("node");
        tableColumn.setWidth(60);
        this.bindTable.setHeaderVisible(true);
        TableKeyListener.bindTableKeyListener(this.bindTable);
        this.bindFiller = new BindNavigateFiller(this.bindTable);
    }

    void packColumns(Table table) {
        int columnCount = table.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn tableColumn = table.getColumn(i);
            tableColumn.pack();
            ++i;
        }
    }

    private void createTableEditor() {
        final TableEditor editor = new TableEditor(this.resultTable);
        this.resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                Point pt = new Point(e.x, e.y);
                TableItem item = MaskatEditViewContent.this.resultTable.getItem(pt);
                if (item == null) {
                    return;
                }
                Text newEditor = new Text((Composite)MaskatEditViewContent.this.resultTable, 4);
                newEditor.setText(item.getText(1));
                newEditor.selectAll();
                editor.grabHorizontal = true;
                editor.setEditor((Control)newEditor, item, 1);
                newEditor.setFocus();
            }
        });
    }

    private String noEmptyString(String s) {
        if (s == null) {
            return null;
        }
        if ("".equals(s.trim())) {
            return null;
        }
        return s;
    }

    private void syncDataToParam() {
        if (this.param == null) {
            return;
        }
        if (this.paramTable != null) {
            ArrayList<SourceProperty> children = new ArrayList<SourceProperty>();
            int i = 0;
            while (i < this.paramTable.getItemCount()) {
                SourceProperty source = new SourceProperty();
                TableItem item = this.paramTable.getItem(i);
                source.setObj(this.noEmptyString(item.getText(0)));
                source.setNode(this.noEmptyString(item.getText(1)));
                source.setChildNode(this.noEmptyString(item.getText(2)));
                source.setIdxRef(this.noEmptyString(item.getText(3)));
                children.add(source);
                ++i;
            }
            this.cs.execute((Command)new SetChildrenCommand(this.param, children));
        }
    }

    private void syncDataToResult() {
        if (this.result == null) {
            return;
        }
        if (this.resultTable != null) {
            ArrayList<TargetProperty> children = new ArrayList<TargetProperty>();
            int i = 0;
            while (i < this.resultTable.getItemCount()) {
                TargetProperty target = new TargetProperty();
                TableItem item = this.resultTable.getItem(i);
                target.setOut(this.noEmptyString(item.getText(0)));
                target.setIn(this.noEmptyString(item.getText(1)));
                target.setInkey(this.noEmptyString(item.getText(2)));
                target.setType(this.noEmptyString(item.getText(3)));
                children.add(target);
                ++i;
            }
            this.cs.execute((Command)new SetChildrenCommand(this.result, children));
        }
    }

    public void acceptData(String componentName) {
        if (this.currentState == 0) {
            return;
        }
        if (this.currentState == 1) {
            this.paramFiller.acceptString(componentName);
        }
        if (this.currentState == 2) {
            this.resultFiller.acceptString(componentName);
        }
        if (this.currentState == 5 || this.currentState == 6) {
            this.bindFiller.acceptString(componentName);
        }
    }
}

