/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.xml;

import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class DefXmlSerializer {
    protected Object def;
    protected Writer writer;
    private int indentSpace = 3;

    protected DefXmlSerializer(Object def, Writer writer) {
        this.def = def;
        this.writer = writer;
    }

    public void write() throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(this.writer);
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeCharacters("\n");
        this.customizeWrite(writer);
        this.writeObj(writer, this.def, 0);
        writer.writeEndDocument();
        writer.flush();
        writer.close();
    }

    protected abstract void customizeWrite(XMLStreamWriter var1) throws XMLStreamException;

    public int getIndentSpace() {
        return this.indentSpace;
    }

    public void setIndentSpace(int indentSpace) {
        this.indentSpace = indentSpace;
    }

    protected abstract void writeObj(XMLStreamWriter var1, Object var2, int var3) throws XMLStreamException;

    protected abstract String getElementName(Object var1);

    protected abstract void writeDefAttribute(XMLStreamWriter var1, Object var2) throws XMLStreamException;

    protected void writeIndent(XMLStreamWriter writer, int hierarchyLvl) throws XMLStreamException {
        int i = 0;
        while (i < hierarchyLvl * this.indentSpace) {
            writer.writeCharacters(" ");
            ++i;
        }
    }

    protected static void writeOneAttribute(XMLStreamWriter writer, String name, String value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        writer.writeAttribute(name, value);
    }
}

