/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.eventdef;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.maskat.framework.BasicDef;
import org.maskat.framework.DefChildIterator;

public class Component extends BasicDef {
	private String id;

	private Map events;

	public void addChild(Object child) {
		super.addChild(child);
		if (child instanceof Event) {
			addEvent((Event) child);
		}
	}

	private void addEvent(Event event) {
		if (events == null)
			events = new HashMap();
		events.put(event.getId(), event);
	}

	public Event removeEvent(String id) {
		return (Event) events.remove(id);
	}

	public Event findEvent(String id) {
		if (events == null)
			return null;
		return (Event) events.get(id);
	}

	public boolean hasEvents() {
		if (events == null || events.size() == 0)
			return false;
		return true;
	}

	public Iterator getAllEvents() {
		if (events == null) {
			return null;
		}
		return new DefChildIterator(this, events.values().iterator());
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

}