/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.eventdef;

import java.util.Iterator;
import java.util.Set;

import org.maskat.framework.BasicDef;

public class Event extends BasicDef {
	private String id;// onclick,onblueƂBBB

	private String ref;// EventRefւ̎Q

	private String start;

	private String before;

	private String after;

	private String finish;

	private String type;

	private String async;

	private String remoteUrl;

	private String timeout;

	private String onTimeoutError;

	// private Map headers;

	// private Param param;

	// private Result result;

	public Event() {

	}

	private boolean enable = true;

	public boolean isEnable() {
		return enable;
	}

	public void setEnable(boolean enable) {
		this.enable = enable;
	}

	// public boolean equals(Object obj) {
	// if (!(obj instanceof Event)) {
	// return false;
	// }
	// if (obj == this) {
	// return true;
	// }
	// // Event o = (Event) obj;
	// // if (!CUtil.isStrEqual(o.id, id))
	// // return false;
	// // if (!CUtil.isStrEqual(o.start, start))
	// // return false;
	// // if (!CUtil.isStrEqual(o.before, before))
	// // return false;
	// // if (!CUtil.isStrEqual(o.after, after))
	// // return false;
	// // if (!CUtil.isStrEqual(o.finish, finish))
	// // return false;
	// // if (!CUtil.isStrEqual(o.type, type))
	// // return false;
	// // if (!CUtil.isStrEqual(o.async, async))
	// // return false;
	// // if (!CUtil.isStrEqual(o.remoteUrl, remoteUrl))
	// // return false;
	//
	// return super.contentEquals(obj);
	// }

	public void getRelatedObjNames(Set resultSet) {
		Param param = (Param) getChildByTypeIdx(Param.class, 0);
		if (param != null) {
			for (Iterator it = param.getSourcesIt(); it != null && it.hasNext();) {
				Source source = (Source) it.next();
				if (source.getObj() != null) {
					resultSet.add(source.getObj());
				}
			}
		}
		Result result = (Result) getChildByTypeIdx(Result.class, 0);
		if (result != null) {
			for (Iterator it = result.getTargetsIt(); it != null && it.hasNext();) {
				Target target = (Target) it.next();
				if (target.getOut() != null) {
					resultSet.add(target.getOut());
				}
			}
		}
	}

	public void addChildToIdx(Object child, int idx) {
		super.addChildToIdx(child, idx);
	}

	public Event(String id) {
		this.id = id;
	}

	public String getAfter() {
		return after;
	}

	public void setAfter(String after) {
		this.after = after;
	}

	public String getAsync() {
		return async;
	}

	public void setAsync(String async) {
		this.async = async;
	}

	public String getBefore() {
		return before;
	}

	public void setBefore(String before) {
		this.before = before;
	}

	public String getFinish() {
		return finish;
	}

	public void setFinish(String finish) {
		this.finish = finish;
	}

	// private void addHeader(Header header) {
	// if (header == null || header.getName() == null) {
	// throw new IllegalArgumentException();
	// }
	// if (headers == null)
	// headers = new HashMap();
	// headers.put(header.getName(), header);
	//
	// }

	// public Header findHeader(String name) {
	// if (headers == null) {
	// return null;
	// }
	// return (Header) headers.get(name);
	// }

	// public Iterator getAllHeaders() {
	// if (headers == null) {
	// return null;
	// }
	// return new DefChildIterator(this, headers.values().iterator());
	// }

	// public boolean hasHeaders() {
	// if (headers == null || headers.size() == 0) {
	// return false;
	// }
	// return true;
	// }

	public Param getParam() {
		Param param = (Param) getChildByTypeIdx(Param.class, 0);
		if (param == null) {
			param = new Param(false);
			addChild(param);
		}
		return param;
	}

	public Result getResult() {
		Result result = (Result) getChildByTypeIdx(Result.class, 0);
		if (result == null) {
			result = new Result(false);
			addChild(result);
		}
		return result;
	}

	public String getStart() {
		return start;
	}

	public void setStart(String start) {
		this.start = start;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getRef() {
		return ref;
	}

	public void setRef(String ref) {
		this.ref = ref;
	}

	public String getRemoteUrl() {
		return remoteUrl;
	}

	public void setRemoteUrl(String remoteUrl) {
		this.remoteUrl = remoteUrl;
	}

	public String getOnTimeoutError() {
		return onTimeoutError;
	}

	public void setOnTimeoutError(String onTimeoutError) {
		this.onTimeoutError = onTimeoutError;
	}

	public String getTimeout() {
		return timeout;
	}

	public void setTimeout(String timeout) {
		this.timeout = timeout;
	}

	public String toString() {
		return "";
	}
}
