/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.util.ArrayList;
import java.util.List;

import org.maskat.framework.IBasicDefVisitor;

public class BasicDefVisitorForSimilarName implements IBasicDefVisitor {
	private String name;

	private List result = null;

	public BasicDefVisitorForSimilarName(String name) {
		this.name = name;
	}

	public void visit(Object def) {
		// XXX ComboItemDef̓ʂȏ͗ǂȂI
		if (def instanceof IComponentDef && !(def instanceof ComboItemDef)) {
			String nameOfExistingComp = ((IComponentDef) def).getName();
			if (nameOfExistingComp != null && nameOfExistingComp.indexOf(this.name) == 0) {
				addAnExistingName(nameOfExistingComp);
			}
		}
	}

	private void addAnExistingName(String name) {
		if (result == null)
			result = new ArrayList();
		result.add(name);
	}

	public boolean hasResult() {
		return result != null && result.size() > 0;
	}

	public boolean resultContains(String name) {
		return result != null && result.contains(name);
	}
}
