/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GridDef extends ComponentDef {
	// private List headers;

	private List lines;

	private String rang;

	private String lineHeight;

	// private String autoWidth;

	private String multiSelect;

	// private String triable;

	private String actifClic;

	private String cellActive;

	// private String basculable;

	private String bNavig;

	private String boolPrint;

	private String sortable;

	private String widthLastCell;

	private String switchable;

	private String autoResizeParent;

	private String writable;

	private String TabEntete;

	private String printTitle;

	private String autoResizeContenu;

	private String tabTypeCol;

	public Iterator getHeadersIt() {
		return this.getTypedChildren(GridHeaderDef.class);
	}

	public void setName(String name) {
		firePropertyChange("text", this.getName(), name);
		super.setName(name);
	}

	public void addChild(Object comp) {
		super.addChild(comp);
		if (comp instanceof GridHeaderDef) {
			((GridHeaderDef) comp).setParent(this);
		}
		if (comp instanceof GridLineDef) {
			addLine((GridLineDef) comp);
		}
		// editpartŃCxg󂯎珈B
		firePropertyChange("addChild", "", null);
	}

	public void addChildToIdx(Object comp, int idx) {
		super.addChildToIdx(comp, idx);
		if (comp instanceof GridHeaderDef) {
			((GridHeaderDef) comp).setParent(this);
		}
		if (comp instanceof GridLineDef) {
			addLine((GridLineDef) comp);
		}
		// editpartŃCxg󂯎珈B
		firePropertyChange("addChild", "", null);
	}

	public void removeChild(Object obj) {
		// XXX headersAlinesBasicDefchildren̈vۂāI
		super.removeChild(obj);
		if (obj instanceof GridLineDef) {
			lines.remove(obj);
		}
		firePropertyChange("removeChild", "", null);
	}

	public int indexOfHeader(GridHeaderDef headerDef) {
		Iterator headersIt = this.getHeadersIt();
		if (headersIt == null) {
			return -1;
		}
		int result = 0;
		while (headersIt.hasNext()) {
			if (headersIt.next().equals(headerDef)) {
				return result;
			}
			result++;
		}
		return -1;
	}

	public int headerTotalWidth() {
		Iterator headersIt = this.getHeadersIt();
		if (headersIt == null) {
			return 0;
		}
		int result = 0;
		while (headersIt.hasNext()) {
			GridHeaderDef header = (GridHeaderDef) headersIt.next();
			result += Integer.parseInt(header.getWidth());
		}
		return result;
	}

	private void addLine(GridLineDef line) {
		if (lines == null)
			lines = new ArrayList();
		lines.add(line);
	}

	public String getActifClic() {
		return actifClic;
	}

	public void setActifClic(String actifClic) {
		this.actifClic = actifClic;
	}

	public String getAutoResizeParent() {
		return autoResizeParent;
	}

	public void setAutoResizeParent(String autoresizeparent) {
		this.autoResizeParent = autoresizeparent;
	}

	public List getLines() {
		return lines;
	}

	public void setLines(List lines) {
		this.lines = lines;
	}

	public String getSortable() {
		return sortable;
	}

	public void setSortable(String sortable) {
		this.sortable = sortable;
	}

	public String getSwitchable() {
		return switchable;
	}

	public void setSwitchable(String switchable) {
		this.switchable = switchable;
	}

	public String getWidthLastCell() {
		return widthLastCell;
	}

	public void setWidthLastCell(String widthlastcell) {
		this.widthLastCell = widthlastcell;
	}

	public String getWritable() {
		return writable;
	}

	public void setWritable(String writable) {
		this.writable = writable;
	}

	public String getBNavig() {
		return bNavig;
	}

	public void setBNavig(String naving) {
		bNavig = naving;
	}

	public String getBoolPrint() {
		return boolPrint;
	}

	public void setBoolPrint(String boolPrint) {
		this.boolPrint = boolPrint;
	}

	public String getCellActive() {
		return cellActive;
	}

	public void setCellActive(String cellActive) {
		this.cellActive = cellActive;
	}

	public String getLineHeight() {
		return lineHeight;
	}

	public void setLineHeight(String lineHeight) {
		this.lineHeight = lineHeight;
		firePropertyChange("lineHeight", null, "");
	}

	public String getMultiSelect() {
		return multiSelect;
	}

	public void setMultiSelect(String multiSelect) {
		this.multiSelect = multiSelect;
	}

	public String getRang() {
		return rang;
	}

	public void setRang(String rang) {
		this.rang = rang;
	}

	public String getAutoResizeContenu() {
		return autoResizeContenu;
	}

	public void setAutoResizeContenu(String autoResizeContenu) {
		this.autoResizeContenu = autoResizeContenu;
	}

	public String getPrintTitle() {
		return printTitle;
	}

	public void setPrintTitle(String printTitle) {
		this.printTitle = printTitle;
	}

	public String getTabEntete() {
		return TabEntete;
	}

	public void setTabEntete(String tabEntete) {
		TabEntete = tabEntete;
	}

	public String getTabTypeCol() {
		return tabTypeCol;
	}

	public void setTabTypeCol(String tabTypeCol) {
		this.tabTypeCol = tabTypeCol;
	}

}
