/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.beans.PropertyChangeListener;

import org.maskat.framework.IBasicDef;

/**
 * Represents a component definition in the layout. <br>
 * Serves as the "model" object in GEF world.<br>
 * <code>IComponentDef</code>s form a tree. <br>
 * Every component should have a name that identifies itself.
 * 
 * @author shengshen
 */
public interface IComponentDef extends IBasicDef {

	/**
	 * Get the <code>IContainerDef</code> which is the container of this
	 * componentDef.
	 * 
	 * @return
	 */
	public IContainerDef getParent();

	/**
	 * The component tree is always within a outer-most container, which is
	 * called the layout definition. The layout definition is a
	 * <code>IComponentDef</code> of course. Calling getLayoutDef on layout
	 * definition will return itself.
	 * 
	 * @return layout definition
	 */
	public LayoutDef getLayoutDef();

	public String getName();

	public void setName(String name);

	public String getTabIndex();

	public void setTabIndex(String tabIndex);

	public int getHeight();

	public void setHeight(int height);

	public int getLeft();

	public void setLeft(int left);

	public int getTop();

	public void setTop(int top);

	public int getWidth();

	public void setWidth(int width);

	public void setConstraint(int left, int top, int width, int height);

	/**
	 * Add the property change listener.
	 * 
	 * @param l
	 */
	public void addPropertyChangeListener(PropertyChangeListener l);

	/**
	 * Fires the "property change" event. Must only be called by the
	 * IComponentDefs (the model objects) to notice the listener of the model
	 * change.
	 * 
	 * @param propName
	 * @param oldValue
	 * @param newValue
	 */
	public void firePropertyChange(String propName, Object oldValue, Object newValue);

	/**
	 * Remove the property change listener.
	 * 
	 * @param l
	 */
	public void removePropertyChangeListener(PropertyChangeListener l);
}