/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.editors;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.maskat.framework.IBasicDefVisitor;
import org.maskat.framework.eventdef.xml.TelegramSchemaGenerator;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.LayoutDef;
import org.maskat.ide.MaskatIDEPlugin;
import org.maskat.ide.MaskatProjectPropertyPage;
import org.maskat.ide.action.CopyComponentAction;
import org.maskat.ide.action.CutComponentAction;
import org.maskat.ide.action.DelComponentAction;
import org.maskat.ide.action.PasteComponentAction;
import org.maskat.ide.gef.editparts.MaskatEditPartFactory;
import org.maskat.ide.property.PropertySourceProviderForEditPart;
import org.maskat.ide.tabbedproperties.MaskatTabbedPropertySheetPage;

public class MaskatEditor extends GraphicalEditor implements
		ITabbedPropertySheetPageContributor {

	public final static String ID = "org.maskat.ide.gef.editor1";

	public boolean gettingFocus = false;

	protected EditorData data;

	public void setFocus() {
		super.setFocus();
		gettingFocus = true;
	}

	public final static int SCREEN_EDIT_MODE = 1;

	public final static int SOURCE_EDIT_MODE = 2;

	public final static int TARGET_EDIT_MODE = 4;

	public int editMode = SCREEN_EDIT_MODE;

	private PaletteSupport paletteSupport;

	public MaskatEditor() {
		DefaultEditDomain ed = new DefaultEditDomain(this);
		paletteSupport = new PaletteSupport(ed);
		setEditDomain(ed);
	}

	Composite splitter;

	public void createPartControl(Composite parent) {
		splitter = paletteSupport.getEditorComposite(parent, getSite().getPage());
		super.createPartControl(splitter);
		paletteSupport.setGraphicalControl(getGraphicalViewer().getControl());
	}

	/**
	 * GfB^[\Rg[
	 * 
	 * @return
	 */
	protected Composite getControl() {
		return splitter;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.gef.ui.parts.GraphicalEditor#initializeGraphicalViewer()
	 */
	protected void initializeGraphicalViewer() {
		GraphicalViewer viewer = getGraphicalViewer();

		// ŏʂ̃f̐ݒ
		genContextMenu();
		viewer.setContents(getCurrentLayoutDef());
		createSourceListener();

		// EditorMenuProvider provider = new EditorMenuProvider();
		// EditPart root = getGraphicalViewer().getRootEditPart().getContents();
		// if (root instanceof AbstractGraphicalEditPart)
		// getGraphicalViewer().setContextMenu(
		// provider.genMenuManager(((AbstractGraphicalEditPart) root)
		// .getFigure()));
	}

	protected void genContextMenu() {
		final GraphicalViewer viewer = getGraphicalViewer();
		MenuManager mm = viewer.getContextMenu();
		if (mm == null) {
			mm = new MenuManager();
			viewer.setContextMenu(mm);
		}
		mm.removeAll();

		MenuManager subMenu = new MenuManager("CAEg");

		Iterator it = data.getLayouts();
		int currentIdx = 0;
		while (it.hasNext()) {
			LayoutDef layoutDef = (LayoutDef) it.next();
			final int theIdx = currentIdx;
			Action action = new Action(layoutDef.getName() == null ? "anonymous" + theIdx
					: layoutDef.getName(), Action.AS_RADIO_BUTTON) {
				public void run() {
					MaskatEditor.this.data.switchLayout(theIdx);
					getGraphicalViewer().setContents(getCurrentLayoutDef());
				}
			};
			action.setId(String.valueOf(theIdx));
			if (currentIdx == 0)
				action.setChecked(true);
			else
				action.setChecked(false);
			subMenu.add(action);
			currentIdx++;
		}
		mm.add(subMenu);
		genContextDelMenu();
	}

	private void genContextDelMenu() {
		final GraphicalViewer viewer = getGraphicalViewer();
		MenuManager mm = viewer.getContextMenu();
		IAction delAction = new DelComponentAction(this);
		getActionRegistry().registerAction(delAction);
		getSelectionActions().add(delAction.getId());
		mm.add(delAction);
	}

	private class ResourceDeltaVisitor implements IResourceDeltaVisitor {

		private IPath targetResourcePath;

		private boolean hit = false;

		public boolean isHit() {
			return hit;
		}

		public ResourceDeltaVisitor(IPath targetResourcePath) {
			this.targetResourcePath = targetResourcePath;
		}

		public boolean visit(IResourceDelta delta) throws CoreException {
			switch (delta.getKind()) {
			case IResourceDelta.ADDED:
				break;
			case IResourceDelta.REMOVED:
				if (delta.getFullPath().equals(targetResourcePath)) {
					hit = true;
				}
				break;
			case IResourceDelta.CHANGED:
				if (delta.getFullPath().equals(targetResourcePath)) {
					hit = true;
				}
				break;
			}
			return true;
		}

	}

	protected LayoutDef getCurrentLayoutDef() {
		return data.getCurrentLayoutDef();
	}

	// XXX
	private boolean isThisEditorSaving = false;

	private IResourceChangeListener listener;

	private void createSourceListener() {
		// GfB^[N[YꂽÃXi[폜
		listener = new IResourceChangeListener() {
			public void resourceChanged(IResourceChangeEvent event) {
				if (MaskatEditor.this.isThisEditorSaving)
					return;

				IEditorInput editorInput = MaskatEditor.this.getEditorInput();
				IFile iFile = (IFile) editorInput.getAdapter(IFile.class);
				ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(iFile
						.getFullPath());
				try {
					event.getDelta().accept(visitor);
				} catch (CoreException e1) {
					e1.printStackTrace();
				}
				if (visitor.isHit()) {
					Display.getDefault().syncExec(new Runnable() {
						public void run() {
							try {
								// TODO CAEg`XMLƃCxg`XMLʁXŁBBB
								MaskatEditor.this.initLoad(MaskatEditor.this
										.getEditorInput());
								data.connectLayoutEvent();
								genContextMenu();
								MaskatEditor.this.getGraphicalViewer().setContents(
										getCurrentLayoutDef());
								MaskatEditor.this.getCommandStack().flush();
								dirty = false;
							} catch (PartInitException e) {
								MaskatIDEPlugin.getDefault().getLog().log(
										new Status(IStatus.ERROR,
												MaskatIDEPlugin.PLUGIN_ID, IStatus.ERROR,
												e.getMessage(), e));
							}

						}
					});
				}
			}
		};
		MaskatIDEPlugin.getWorkspace().addResourceChangeListener(listener);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.ui.part.EditorPart#doSave(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor) {
		try {
			isThisEditorSaving = true;
			// XXX ptH[}X
			StringWriter strWriter = new StringWriter(1024);
			data.writeLayout(strWriter);

			// Iterator it = data.getLayouts();
			// while (it.hasNext()) {
			// ((LayoutDef) it.next()).removeAllByType(RadioGroupDef.class);
			// }
			// RadioGroupDef should not be remained as a direct child of
			// layoutDef

			byte[] bytes = strWriter.toString().getBytes("UTF-8");
			layoutXmlFile.setContents(new ByteArrayInputStream(bytes), false, false,
					monitor);

			// Cxg`XMLZ[u
			String[] results = data.writeEvent();

			IProject project = this.layoutXmlFile.getProject();
			String confirmOption = project
					.getPersistentProperty(MaskatProjectPropertyPage.SCHEMA_GENERATE_PROPERTY);
			if (confirmOption == null)
				confirmOption = "2";

			boolean confirm = true;
			if ("1".equals(confirmOption)) {
				confirm = false;
			}
			if ("2".equals(confirmOption)) {
				confirm = MessageDialog.openConfirm(this.getSite().getShell(), "XL[}",
						"XL[}܂A낵łH");
			}
			if (confirm) {
				for (int i = 0; i < results.length; i++) {
					String result = results[i];
					IPath path = layoutXmlFile.getProjectRelativePath();
					TelegramSchemaGenerator.generate(new ByteArrayInputStream(result
							.getBytes("UTF-8")), project, path.removeLastSegments(1));
				}
			}

			getCommandStack().markSaveLocation();
			dirty = false;

			firePropertyChange(IEditorPart.PROP_DIRTY);
			firePropertyChange(PROP_SAVE);
		} catch (CoreException e) {
			ErrorDialog.openError(this.getSite().getShell(), "ۑ", // ^Cg
					"ۑɎs܂B", // G[bZ[W
					e.getStatus());
			MaskatIDEPlugin.getDefault().getLog().log(e.getStatus());
		} catch (Exception e) {
			IStatus status = new Status(IStatus.ERROR, // Xe[^X: G[
					MaskatIDEPlugin.PLUGIN_ID, // vOCID
					0, // G[R[h
					e.getMessage() == null ? "" : e.getMessage(), // G[bZ[W
					e); // OIuWFNg
			ErrorDialog.openError(this.getSite().getShell(), "ۑ", // ^Cg
					"ۑɎs܂B", // G[bZ[W
					status);
			MaskatIDEPlugin.getDefault().getLog().log(status);
		} finally {
			isThisEditorSaving = false;
		}

	}

	public static final int PROP_SAVE = 0x200;

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.ui.part.EditorPart#doSaveAs()
	 */
	public void doSaveAs() {

	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.ui.part.EditorPart#isDirty()
	 */
	public boolean isDirty() {
		return getCommandStack().isDirty() || dirty;
	}

	private boolean dirty = false;

	/**
	 * Note: Should only be used in EventPropertySection!!
	 * 
	 */
	public void makeDirty() {
		dirty = true;
		firePropertyChange(IEditorPart.PROP_DIRTY);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.ui.part.EditorPart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.gef.ui.parts.GraphicalEditor#commandStackChanged(java.util.EventObject)
	 */
	public void commandStackChanged(EventObject event) {
		super.commandStackChanged(event);
		// GfB^[̕ύX}[NXV
		firePropertyChange(IEditorPart.PROP_DIRTY);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.gef.ui.parts.GraphicalEditor#configureGraphicalViewer()
	 */
	protected void configureGraphicalViewer() {
		super.configureGraphicalViewer();

		GraphicalViewer viewer = getGraphicalViewer();
		// EditPartFactory̍쐬Ɛݒ
		viewer.setEditPartFactory(new MaskatEditPartFactory());

		// Listener listener = new Listener() {
		// public void handleEvent(Event event) {
		// handleActivationChanged(event);
		// }
		// };
		// splitter.addListener(SWT.Activate, listener);
		// splitter.addListener(SWT.Deactivate, listener);

	}

	// private IFile eventXmlFile;

	private IFile layoutXmlFile;

	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		initLoad(input);

		// ӁAsuper.initinitLoaďŌĂяo
		// initLoadPartInitException𓊂ꂽAsuper.initselectionListenerłɓo^Ă܂̂ŁA܂
		super.init(site, input);
	}

	private void initLoad(IEditorInput input) throws PartInitException {
		layoutXmlFile = (IFile) input.getAdapter(IFile.class);

		// CAEgXMLƑΉCxg`XMLt@C擾
		// IProject project = layoutXmlFile.getProject();
		// IPath path = layoutXmlFile.getProjectRelativePath();
		//
		// String lastSegment = path.lastSegment();
		// int index = lastSegment.lastIndexOf("xml") - 1;
		// path = path.removeLastSegments(1).append(
		// lastSegment.substring(0, index) + "_e.xml");

		// eventXmlFile = project.getFile(path);// Cxg`XMLt@C擾

		if (layoutXmlFile != null) {
			setPartName(layoutXmlFile.getName());
		}

		this.data = new EditorData(layoutXmlFile);
		try {
			data.loadLayout();
			data.loadEvent();

			autoGenerateName();
		} catch (CoreException e) {
			MaskatIDEPlugin.getDefault().getLog().log(
					new Status(IStatus.ERROR, MaskatIDEPlugin.PLUGIN_ID, 0,
							"CAEg`ƃCxg`[hG[B", e));
			throw new PartInitException(e.getStatus());
		} catch (Exception e) {
			IStatus status = new Status(IStatus.ERROR, // Xe[^X: G[
					MaskatIDEPlugin.PLUGIN_ID, // vOCID
					0, // G[R[h
					e.getMessage() == null ? "" : e.getMessage(), // G[bZ[W
					e); // OIuWFNg
			throw new PartInitException(status);
		}
		data.connectLayoutEvent();
	}

	private void autoGenerateName() {
		for (Iterator it = data.getLayouts(); it.hasNext();) {
			final LayoutDef layoutDef = (LayoutDef) it.next();
			layoutDef.accept(new IBasicDefVisitor() {

				public void visit(Object def) {
					if (def instanceof IComponentDef) {
						IComponentDef comp = (IComponentDef) def;
						if (comp.getName() == null) {
							comp.setName("generated_name");
							layoutDef.setAppropriateNameForComponent(comp);
						}
					}

				}
			});
		}

	}

	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		super.selectionChanged(part, selection);
		if (selection instanceof TextSelection) {
			TextSelection txtSel = (TextSelection) selection;
			List targets = new ArrayList();
			if (txtSel.getText() == null)// || getGraphicalViewer() == null)
				return;
			searchForNamedComponent(getGraphicalViewer().getRootEditPart().getContents(),
					txtSel.getText(), targets);
			getGraphicalViewer().deselectAll();// selection
			for (int i = 0; i < targets.size(); i++) {
				EditPart target = (EditPart) targets.get(i);
				getGraphicalViewer().appendSelection(target);
				if (i == 0) {
					getGraphicalViewer().reveal(target);
				}
			}
		}
	}

	/**
	 * EditPart̃c[A閼OeditPart􂢏o
	 * 
	 * @param root
	 * @param name
	 * @return
	 */
	public void searchForNamedComponent(EditPart root, String name, List list) {
		if (root == null || root.getChildren() == null) {
			return;
		}
		for (int i = 0; i < root.getChildren().size(); i++) {
			EditPart editPart = (EditPart) root.getChildren().get(i);
			if (editPart.getModel() instanceof IComponentDef) {
				if (name.equals(((IComponentDef) editPart.getModel()).getName())) {
					list.add(editPart);
				}
			}
			searchForNamedComponent(editPart, name, list);
		}
	}

	public void dispose() {
		MaskatIDEPlugin.getWorkspace().removeResourceChangeListener(listener);
		super.dispose();
	}

	public Object getAdapter(Class type) {
		if (type == IPropertySheetEntry.class) {
			PropertySheetEntry entry = new UndoablePropertySheetEntry(getCommandStack());
			entry.setPropertySourceProvider(PropertySourceProviderForEditPart.ins);
			return entry;
		}
		if (type == IPropertySheetPage.class) {
			if (type == IPropertySheetPage.class)
				return new MaskatTabbedPropertySheetPage(this);
			// return new MaskatTabbedPropertySheetPage(this);
			// MaskatEditorƂɁAPropertySheetPageĂ
			// PropertySheetPage page = new MaskatPropertySheetPage();
			// PropertySheetEntry entry = new UndoablePropertySheetEntry(
			// getCommandStack());
			// entry.setPropertySourceProvider(PropertySourceProviderForEditPart.ins);
			// page.setRootEntry(entry);
			//
			// return page;
		}
		Object result = paletteSupport.getAdapter(type);
		if (result != null)
			return result;

		return super.getAdapter(type);
	}

	/**
	 * MaskatPropertySheetPage#selectionChangedQlĂ
	 * vpeBr[ɕ\Ăselection
	 */
	private ISelection lastSelectionForEdit;

	public ISelection getLastSelectionForEdit() {
		return lastSelectionForEdit;
	}

	public void setLastSelectionForEdit(ISelection lastSelectionForEdit) {
		this.lastSelectionForEdit = lastSelectionForEdit;
	}

	public String getContributorId() {
		return getSite().getId();
	}

	protected void createActions() {
		super.createActions();
		ActionRegistry registry = getActionRegistry();

		// ̐ANV
		IAction action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.LEFT);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this, PositionConstants.CENTER);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this, PositionConstants.RIGHT);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		// ̐ANV
		action = new AlignmentAction((IWorkbenchPart) this, PositionConstants.TOP);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this, PositionConstants.MIDDLE);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this, PositionConstants.BOTTOM);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new CopyComponentAction(this);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new CutComponentAction(this);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new PasteComponentAction(this);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());
	}

	protected void handleActivationChanged(Event event) {
		IAction copy = null;
		if (event.type == SWT.Deactivate)
			copy = getActionRegistry().getAction(ActionFactory.COPY.getId());
		if (getEditorSite().getActionBars().getGlobalActionHandler(
				ActionFactory.COPY.getId()) != copy) {
			getEditorSite().getActionBars().setGlobalActionHandler(
					ActionFactory.COPY.getId(), copy);
			getEditorSite().getActionBars().updateActionBars();
		}
	}

	public void syncMousePointerWithMode() {
		if (this.editMode == SOURCE_EDIT_MODE || editMode == TARGET_EDIT_MODE) {
			((FigureCanvas) this.getGraphicalViewer().getControl())
					.getLightweightSystem().getRootFigure().setCursor(Cursors.UPARROW);
		} else {
			((FigureCanvas) this.getGraphicalViewer().getControl())
					.getLightweightSystem().getRootFigure().setCursor(Cursors.ARROW);
		}
	}
}
