/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.editors;

import org.eclipse.jface.dialogs.IInputValidator;

public class VarNameInputValidator implements IInputValidator {

	public final static IInputValidator validator = new VarNameInputValidator();

	public String isValid(String newText) {

		if (isValidJavaIdentifier(newText)) {
			return null;
		}
		return "Lȕϐ͂ĂB";
	}

	public static boolean isValidJavaIdentifier(String string) {

		if ((string == null) || (string.length() == 0))
			return false;

		char[] chars = string.toCharArray();

		// -- make sure starting character is valid
		if (!Character.isJavaIdentifierStart(chars[0]))
			return false;

		for (int i = 1; i < chars.length; i++) {
			if (!Character.isJavaIdentifierPart(chars[i]))
				return false;
		}
		// if (isKeyword(string)) return false;
		return true;
	}
}
