/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.editors.linkeventsrc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LayoutFileCfg {
	private String name;

	private List eventFileCfgs;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void addEventFileCfg(EventFileCfg evtFileCfg) {
		if (eventFileCfgs == null)
			eventFileCfgs = new ArrayList();
		eventFileCfgs.add(evtFileCfg);
	}

	public String[] getEventFileNames() {
		if (eventFileCfgs == null || eventFileCfgs.size() == 0)
			return null;
		List result = new ArrayList();
		for (Iterator it = eventFileCfgs.iterator(); it.hasNext();) {
			EventFileCfg evt = (EventFileCfg) it.next();
			if (evt.getName() != null)
				result.add(evt.getName());
		}
		return (String[]) result.toArray(new String[result.size()]);
	}
}
