/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editpolicies;

import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.maskat.framework.screendef.TreeNodeDef;
import org.maskat.ide.gef.commands.DelBasicDefCommand;

public class TreeNodeComponentEditPolicy extends MaskatComponentEditPolicy {

	protected Command createDeleteCommand(GroupRequest deleteRequest) {

		TreeNodeDef model = (TreeNodeDef) getHost().getModel();
		return new DelBasicDefCommand(model.getParentDef(), model);
	}

	protected boolean canFeedbackToRequest(Request request) {
		return true;
	}
}
