/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import org.eclipse.ui.views.properties.IPropertySource;

public abstract class AbstractMaskatPropertySource implements IPropertySource {

	public Object getPropertyValue(Object id) {
		Object result = doGetPropertyValue(id);
		if (result == null)
			return "";
		return result;
	}

	abstract public Object doGetPropertyValue(Object id);

	abstract public void doSetPropertyValue(Object id, Object value);

	public void setPropertyValue(Object id, Object value) {
		if ("".equals(value)) {
			value = null;
			//PropertySourceɋ󔒕nȂ悤
			//xml name="" ̂悤attributeo͂Ȃ悤
		}
		doSetPropertyValue(id, value);
	}
}
