/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.framework.eventdef.Bind;
import org.maskat.ide.property.descriptor.MaskatTextPropertyDescriptor;

public class BindProperty extends Bind implements IPropertySource {

	private static final String PROP_FROMKEY = "_prop_fromkey_";

	private static final String PROP_TOKEY = "_prop_tokey_";

	private static final String PROP_NODE = "_prop_node_";

	private static final String PROP_SENDBLANKELEMENT = "_prop_sendblankelement_";

	private static final IPropertyDescriptor[] descriptors = new PropertyDescriptor[] {
			new MaskatTextPropertyDescriptor(PROP_FROMKEY, "fromkey"),
			new MaskatTextPropertyDescriptor(PROP_TOKEY, "tokey"),
			new MaskatTextPropertyDescriptor(PROP_NODE, "node"),
			new MaskatTextPropertyDescriptor(PROP_SENDBLANKELEMENT, "sendBlankElement") };

	// private Bind bind;

	public BindProperty() {
		// this.bind = bind;
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return descriptors;
	}

	public Object getPropertyValue(Object id) {
		if (PROP_FROMKEY.equals(id)) {
			return getFromkey();
		}
		if (PROP_TOKEY.equals(id)) {
			return getTokey();
		}
		if (PROP_NODE.equals(id)) {
			return getNode();
		}
		if (PROP_SENDBLANKELEMENT.equals(id)) {
			return getSendBlankElement();
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {

	}

	public void setPropertyValue(Object id, Object value) {
		if (PROP_NODE.equals(id)) {
			setNode((String) value);
		}
		if (PROP_FROMKEY.equals(id)) {
			setFromkey((String) value);
		}
		if (PROP_TOKEY.equals(id)) {
			setTokey((String) value);
		}
		if (PROP_SENDBLANKELEMENT.equals(id)) {
			setSendBlankElement((String) value);
		}
	}

}
