/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.tabbedproperties;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.maskat.ide.editors.MaskatEditor;

public class TextControlWrapper extends ControlWrapper {

	private Text text;

	public Control createControl(Composite parent, int style) {
		text = new Text(parent, style);
		return text;
	}

	public String getValue() {
		return text.getText();
	}

	public void setValue(String text) {
		this.text.setText(text);
	}

	public Control getControl() {
		return text;
	}

	public void setValueWatcher(Object obj, String prop, MaskatEditor editor) {
		text.addFocusListener(new TextValueWatcher(text, obj, prop, editor));
	}
}
