package org.maskat.demo.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationFilter implements Filter {

	protected List uncheckUrl = new ArrayList();

	protected static String AUTH_INFO_KEY;

	protected String urlOnAuthFailed;

	public void destroy() {

	}

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		if (authNeeded(request, response)) {
			((HttpServletResponse) response).addHeader("Expire", "now");
			((HttpServletResponse) response).setHeader("Pragma", "no-cache");
			// ログインチェック
			if (!authenticate(request, response)) {
				// 認証失敗の場合
				authFailed(request, response);
				return;
			}
		}
		chain.doFilter(request, response);
	}

	/**
	 * 子クラスはこのメソッドをオーバーライトできる
	 * 
	 * @param request
	 * @param response
	 * @return 認証必要があるかフラグ
	 */
	protected boolean authNeeded(ServletRequest request,
			ServletResponse response) {
		HttpServletRequest httpReq = (HttpServletRequest) request;
		String url = String.valueOf(httpReq.getServletPath());
		if (!uncheckUrl.contains(url) && url.endsWith("xml")) {
			return true;
		}
		return false;
	}

	/**
	 * 子クラスはこのメソッドをオーバーライトできる
	 * 
	 * @param request
	 * @param response
	 * @return 認証成功したかフラグ
	 */
	protected boolean authenticate(ServletRequest request,
			ServletResponse response) {
		HttpServletRequest httpReq = (HttpServletRequest) request;
		if (httpReq.getSession().getAttribute(AUTH_INFO_KEY) == null) {
			return false;
		}
		return true;
	}

	/**
	 * 子クラスはこのメソッドをオーバーライトできる
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	protected void authFailed(ServletRequest request, ServletResponse response)
			throws ServletException, IOException {
		request.getRequestDispatcher(urlOnAuthFailed)
				.forward(request, response);
	}

	public void init(FilterConfig config) throws ServletException {
		AUTH_INFO_KEY = config.getInitParameter("AUTH_INFO_KEY");
		urlOnAuthFailed = config.getInitParameter("URL_ON_AUTH_FAILED");
		String urlParam = config.getInitParameter("UNCHECK_URL");
		if (urlParam != null) {
			String[] urls = urlParam.split(",");
			for (int i = 0; i < urls.length; i++) {
				uncheckUrl.add(urls[i]);
			}
		}
	}
}