package org.maskat.demo.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.maskat.demo.AbstractValueObj;


public class SampleServlet extends HttpServlet {

	private String PACKAGE_NAME = "org.maskat.demo.";

	/**
	 * 
	 */
	private static final long serialVersionUID = 6169907056984915450L;

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		request.setCharacterEncoding("UTF-8");

//		BufferedReader reader = new BufferedReader(request.getReader());
//		String line = null;
//		while ((line = reader.readLine()) != null) {
//			System.out.println(line);
//		}
		// DebugUtil.printRequestHeaderInfo(request);

		// TODO requestから、layoutID、componentID、eventIDを取り出して、対応するクラスのメソッドを呼び出す
		String layoutID = request.getHeader("maskat_layoutID");
		String componentID = request.getHeader("maskat_componentID");
		String eventID = request.getHeader("maskat_eventID");
		Object voObj = null;
		try {

			String packageName = calcPackageName(layoutID, componentID);

			// DAOクラスインスタンスを生成
			// TODO インスタンスキャッシュ
			Class daoClass = Class.forName(packageName + ".DAO");
			Object daoObj = daoClass.newInstance();

			// AbstractValueObjを生成
			// TODO voObjをセッションにキャッシュ？
			Class voClass = Class.forName(packageName + ".vo.ValueObj");
			voObj = voClass.getConstructor(
					new Class[] { HttpServletRequest.class }).newInstance(
					new Object[] { request });
			// TODO どうやってパラメータをvoに渡すのか
			// 電文はXML、XML->object、xml binding部品
			// Castor, betwixt, JaxMeなどいくつか選択できる

			daoClass.getMethod(eventID, new Class[] { AbstractValueObj.class })
					.invoke(daoObj, new Object[] { voObj });
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		}
		response.setContentType("text/xml;charset=UTF-8");
		PrintWriter out = response.getWriter();
		AbstractValueObj avo = (AbstractValueObj) voObj;

		// TODO vo->クライアントへ送信電文
		// xml binding
		// xmlスキーマがある場合、スキーマに合わないといけない
		// binding部品は出力XMLのスキーマがカスタマイズできるべき
		String temp = avo.tempGetXML();
		out.println(temp);
		System.out.println("クライアントへ送信電文:" + temp);
	}

	private String calcPackageName(String layoutID, String componentID) {
		if (componentID == null || "".equals(componentID)) {
			return PACKAGE_NAME + layoutID;
		}
		return PACKAGE_NAME + layoutID + "." + componentID;
	}

}