/*
 * Copyright 2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
if (typeof maskat == "undefined"){
	maskat={};
}
if (typeof maskat.widget == "undefined"){
    maskat.widget={};
}
if (typeof maskat.syntax == "undefined"){
	maskat.syntax={};
}

maskat.widget.Window = function(objPar){
    objPar.boolMaxi = false;
    this.canMin = false;
    if (rialto.lang.isBoolean(objPar.canMin)){
        this.canMin = objPar.canMin;
    }
    this.title="screen";
    if (rialto.lang.isString(objPar.title)){
        this.title = objPar.title;
    }
    objPar.dynamic = true;
    objPar.open = true;
    this.frame = new rialto.widget.Frame(objPar);
    if (this.frame.bMAX)
        this.frame.bMAX.setVisible(false);
    if (this.canMin == false){
        this.frame.BTN.setVisible(false);
    }

    this.statusDiv = document.createElement("div");
    this.statusDiv.style.position="absolute";
    this.statusDiv.style.left=0;
    this.statusDiv.style.width="100%";
    this.statusDiv.style.height=23;
    this.frame.divExt.appendChild(this.statusDiv);
    if (rialto.lang.isString(objPar.statusClassName) && rialto.string.trim(objPar.statusClassName) != ""){
        this.statusClassName = objPar.statusClassName;
        this.statusDiv.className=this.statusClassName;
    }else{
        this.statusDiv.className="window_message";
    }

    var oThis = this;
    this.frame.toolBar.ondbleclick=function(){
        if (oThis.canMin){
            oThis.frame.setDisplay(!oThis.frame.open);
            if (oThis.frame.open)
                oThis.statusDiv.style.display = "block";
            else
                oThis.statusDiv.style.display = "none";
	    }
    }
    if (this.frame.BTN!=null){
        this.frame.BTN.onclick=function(){
            oThis.frame.setDisplay(!oThis.frame.open);
            if (oThis.frame.open)
	            oThis.statusDiv.style.display = "block";
	        else
	            oThis.statusDiv.style.display = "none";
        }
    }
    if (this.frame.labelTitle!=null){
        this.frame.labelTitle.divExt.style.display="none";
    }
    this.titleDiv = document.createElement("div");
    this.titleDiv.className = "window_title";
    this.titleDiv.innerHTML=this.title;
    this.frame.toolBar.divExt.appendChild(this.titleDiv);

    this.msgs = new Array();
    this.msgIdx = 0;
    this.statusDiv.onclick = function(e){
        oThis.msgIdx++;
        oThis.showCurrentMsg();
    }
}

maskat.widget.Window.prototype = new rialto.widget.AbstractContainer;

maskat.widget.Window.prototype.getHtmlCont=function(){
    return this.frame.getHtmlCont();
}

maskat.widget.Window.prototype.placeIn=function(par){
    this.frame.placeIn(par);
}

maskat.widget.Window.prototype.setMsg=function(msg){
    if (typeof msg == "string") {
        this.msgs = new Array(msg);
        this.msgIdx = 0;
    }
    if (msg instanceof Array) {
        this.msgs = msg;
        this.msgIdx = 0;
    }
    this.showCurrentMsg();
}

maskat.widget.Window.prototype.showCurrentMsg = function(){
    var msgToShow = "";
    if (this.msgs.length != 0){
		if (this.msgIdx > this.msgs.length - 1 || this.msgIdx < 0){
		    this.msgIdx = 0;
		}
		msgToShow = this.msgs[this.msgIdx];
    }
    this.statusDiv.innerHTML=msgToShow;
}

maskat.widget.Window.prototype.setTitle=function(msg){
    this.titleDiv.innerHTML=msg;
}

maskat.widget.Window.prototype.remove=function(){
    this.frame.remove();
    this.titleDiv.onclick=null;
}

maskat.syntax["screen"]= {
    name: {type: "string"},
    top: {type: "number"},
    left: {type: "number"},
    width: {type: "number"},
    height: {type: "number"},
    title: {type: "string"},
    draggable: {type:"boolean"},
    canMin: {type:"boolean"},
    statusClassName: {type: "string"},
    parent: {type: "object"}
  };

maskat.transScreenTag = function(pathObjArray, domElem){
  var attr = {};

  //// 属性の取得
  maskat.receiveAttributes(domElem, attr);

  //// 前変換

  // pathObjArrayの要素を降順に走査し、isContainerプロパティがtrue
  // のオブジェクトのgetRefObjメソッドの戻り値を取得する
  var refObjName=null;
  for (var i = pathObjArray.length - 1; i >= 0; i--){
    if (pathObjArray[i].isContainer){
      refObjName = pathObjArray[i].getRefObj();
      break;
    }
  }

  attr["parent"] = refObjName;

  var strObjPar = maskat.composeParam(domElem, attr);

  var output = attr.name + " = new maskat.widget.Window(" + strObjPar + ");\n";
  output += "layoutObj.components[\"" + attr.name + "\"]="+attr.name+";\n";
  
  //// 子供の処理
  if (domElem.hasChildNodes()){
    // 自タグのオブジェクトを作成
    var popupObj = new maskat.ScreenClass(attr.name);
    pathObjArray.push(popupObj);

    // 全ての子供の処理
    output += maskat.transChildNodes(pathObjArray, domElem);
  }
  
  return output;
}

maskat.ScreenClass = function(name){
  this.name = name;
}
maskat.ScreenClass.prototype.isContainer = true;
maskat.ScreenClass.prototype.getRefObj = function(){ return this.name; }

maskat.validationErrorHandler=function(errors){
    var windows = new Array();
    var messagesOfWindows = new Array();
	for (var i=0;i<errors.length;i++){
		var error = errors[i];
		var obj = maskat.getObjByName(error.vTarget.objName);
		var windowParent = maskat.findParentWindow(obj);
		if (windowParent!=null){
			var idx;
			var messages;
			for (idx=0;idx<windows.length;idx++){
				if (windows[idx]==windowParent){
				    messages = messagesOfWindows[idx];
				    break;
				}
			}
			if (idx==windows.length){
			    windows[idx] = windowParent;
			    messages = messagesOfWindows[idx] = new Array();
			}
			//臨時保存
			messages[messages.length] = "<span style='color:red'>" + error.vTarget.desc+ ":" + error.message + "</span>";
		}else{
		    //ウィンドウの子部品ではない場合は、alertでエラーメッセージ表示
            alert(error.vTarget.desc+ ":" + error.message);
        }
	}
	for (var i=0;i<windows.length;i++){
		//windowParentにエラー表示
	    windows[i].setMsg(messagesOfWindows[i]);
	}
}

/**
 * maskatObjの親コンポーネントから一階層ずつ上に行って、maskat.widget.Windowの親コンポーネントを探し
 * 見つからなければ、nullを返す
 */
maskat.findParentWindow = function(maskatObj, limit){
    if (typeof limit != "number")
        limit = 10; //デフォルトは最大10回
    if (limit == 0)
        return null;
    if (maskatObj != null){
        if (!maskatObj.inParent){
            if (maskatObj.oRia != null){
                return maskat.findParentWindow(maskatObj.oRia, limit - 1);
            } else
                return null;
        }
        if (maskatObj.inParent instanceof maskat.widget.Window){
            return maskatObj.inParent;
        }
        return maskat.findParentWindow(maskatObj.inParent, limit - 1);
    }
    return null;
}