/*
 * Copyright (c)  2006-2009 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 /**
 * @class
 * レイアウトのツリー構造を走査し、上位の要素から順番にマスカット部品の
 * 表示非表示処理を実行します。
 *
 * @name maskat.layout.WidgetVisibilityVisitor
 * @extends maskat.layout.WidgetVisitor
 */
maskat.lang.Class.declare("maskat.layout.WidgetVisibilityVisitor")
	.extend("maskat.layout.WidgetVisitor", {

	/** @scope maskat.layout.WidgetVisibilityVisitor.prototype */
	
	/**
	 * コンストラクタです。
	 *
	 * @param enable 表示の場合は true、非表示の場合は false
	 */
    initialize: function(visible) {
		this.visible = visible;
	},
	
	postVisit: function(widget) {
		widget.setVisible(this.visible);
	}
});
