<?php
/*
 * Copyright (c)  2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* 要求メッセージを解析し、パラメータ配列へ格納する */
require_once("../lib/maskat.php");
$param = parse_request_xml();
$store = read_csv_file("data/gourmet_restaurants.csv");

/* 応答メッセージを出力 */
header("Content-Type: text/xml;charset=UTF-8");
echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
?>
<response>
  <restaurants>
<?php
foreach ($store as $restaurant) {
  /* 予算下限額 */
  if ($param["budgetLowerLimit"] &&
      $param["budgetLowerLimit"] > $restaurant["budget"]) {
    continue;
  }

  /* 予算上限額 */
  if ($param["budgetUpperLimit"] &&
      $param["budgetUpperLimit"] < $restaurant["budget"]) {
      continue;
  }

  /* 料理スタイルがいずれも指定されていない場合はすべてにマッチ  */
  $match = ($param["western"] != "true")
    && ($param["japanese"] != "true")
    && ($param["chinese"] != "true");

  /* 料理スタイル (0:洋食／1:和食／2:中華) */
  switch ($restaurant["style"]) {
    case 0:
      $style = "洋食";
      $match |= ($param["western"] == "true");
      break;
    case 1:
      $style = "和食";
      $match |= ($param["japanese"] == "true");
      break;
    case 2:
      $style = "中華";
      $match |= ($param["chinese"] == "true");
      break;
  }
  if (!$match) {
    continue;
  }

  /* クーポンの種類 (1:あり／0:なし) */
  if ($param["coupon"] == "true" && !$restaurant["coupon"]) {
    continue;
  }
  $coupon = ($restaurant["coupon"]) ? "あり" : "なし";
?>
    <restaurant>
      <name><?php echo $restaurant["name"]; ?></name>
      <address><?php echo $restaurant["address"]; ?></address>
      <style><?php echo $style; ?></style>
      <budget><?php echo $restaurant["budget"]; ?></budget>
      <coupon><?php echo $coupon; ?></coupon>
      <latitude><?php echo $restaurant["latitude"]; ?></latitude>
      <longitude><?php echo $restaurant["longitude"]; ?></longitude>
      <description><?php echo $restaurant["description"]; ?></description>
    </restaurant>
<?php
}
?>
  </restaurants>
</response>
