/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
	private static final String BUNDLE_NAME = MaskatUIPlugin.PLUGIN_ID
	+ ".messages"; //$NON-NLS-1$
	
	private static final ResourceBundle RESOURCE_BUNDLE
	= ResourceBundle.getBundle(BUNDLE_NAME);

	public static String getString(String key) {
		try {
			return RESOURCE_BUNDLE.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}
	
	public static String format(String key, Object[] arguments) {
		try {
			String pattern = RESOURCE_BUNDLE.getString(key);
			if (arguments == null || arguments.length == 0) {
				return pattern;
			} else {
				return MessageFormat.format(pattern, arguments);
			}
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}

	public static String format(String key, boolean argument) {
		return format(key, Boolean.valueOf(argument));
	}

	public static String format(String key, short argument) {
		return format(key, new Short(argument));
	}

	public static String format(String key, int argument) {
		return format(key, new Integer(argument));
	}

	public static String format(String key, long argument) {
		return format(key, new Long(argument));
	}

	public static String format(String key, float argument) {
		return format(key, new Float(argument));
	}

	public static String format(String key, double argument) {
		return format(key, new Double(argument));
	}

	public static String format(String key, Object argument) {
		return format(key, new Object[] { argument });
	}
	
	private Messages() {
		// NOP
	}
}
