/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.commands;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.ui.Messages;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;


public class ChangeConstraintCommand extends Command {
	
	private Component nodeElement;

	private Rectangle newConstraint;
	
	private Rectangle oldConstraint;

	public ChangeConstraintCommand(Component node, Rectangle newConstraint) {
		super(node.getName() + Messages.getString("layout.cmd.constraint.msg")); //$NON-NLS-1$
		this.nodeElement = node;
		this.newConstraint = newConstraint;
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	public void execute() {
		doExecute();
	}

	private void doExecute() {
		this.oldConstraint = new Rectangle(nodeElement.getLeft(), nodeElement
				.getTop(), nodeElement.getWidth(), nodeElement.getHeight());
		nodeElement.setConstraint(newConstraint.x, newConstraint.y, newConstraint.width,
				newConstraint.height);
	}

	public boolean canUndo() {
		return true;
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
		nodeElement.setConstraint(oldConstraint.x, oldConstraint.y,
				oldConstraint.width, oldConstraint.height);
	}

}
