/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.Container;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.commands.AddComponentCommand;
import jp.sf.maskat.ui.editors.layout.commands.ChangeConstraintCommand;
import jp.sf.maskat.ui.editors.layout.editpolicies.ComponentXYLayoutEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.DataBindingEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.FeedBackComponentEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.LabelDirectEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.MaskatComponentEditPolicy;
import jp.sf.maskat.ui.editors.layout.tools.TextCellEditorLocator;
import jp.sf.maskat.ui.editors.layout.tools.TextDirectEditManager;
import jp.sf.maskat.ui.views.properties.AbstractComponentPropertySource;
import jp.sf.maskat.ui.views.properties.DynaBeanPropertySource;
import jp.sf.maskat.ui.views.properties.LayoutPropertySource;
import jp.sf.maskat.ui.views.properties.advanced.AdvancedPropertySheetSection;
import jp.sf.maskat.ui.views.properties.tabbed.TabbedEventPropertySheetPage;

import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheet;

public class LayoutElementEditPart extends AbstractGraphicalEditPart
	implements PropertyChangeListener {
	
	protected IFigure createFigure() {
		return new Figure();
	}

	protected void createEditPolicies() {
		int style = FeedBackComponentEditPolicy.getStyle(this);
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new MaskatComponentEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new ComponentXYLayoutEditPolicy(style));
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new LabelDirectEditPolicy());
		installEditPolicy("Snap Feedback", new SnapFeedbackPolicy());
		installEditPolicy(DataBindingEditPolicy.ROLE, new DataBindingEditPolicy());
	}
	
	public void activate() {
		super.activate();
		if (getModel() instanceof Component) {
			((Component) getModel()).addPropertyChangeListener(this);
		}
	}

	public void deactivate() {
		if (getModel() instanceof Component) {
			((Component) getModel()).removePropertyChangeListener(this);
		}
		super.deactivate();
	}

	public void propertyChange(PropertyChangeEvent evt) {
		refreshVisuals();
		refreshAdvancedPropertySheet();
	}	
	
	protected void refreshVisuals() {
		Component comp = (Component) getModel();
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), comp.getWidth(),
				comp.getHeight());
		GraphicalEditPart editPart = (GraphicalEditPart) getParent();
		if (editPart != null) {
			editPart.setLayoutConstraint(this, getFigure(), constraint);
		}
	}
	
	protected void refreshAdvancedPropertySheet() {
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
		if (page == null) {
			return;
		}
		
		IViewPart vp = page.findView(IPageLayout.ID_PROP_SHEET); 
		if (vp == null) {
			return;
		}

		PropertySheet ps = (PropertySheet)vp;
		IPage cp = ps.getCurrentPage();
		if (cp != null && cp instanceof TabbedEventPropertySheetPage) {
			TabbedEventPropertySheetPage viewer = (TabbedEventPropertySheetPage)cp;
			TabWrapper tab = new TabWrapper(viewer);
			for (int i=0; tab!= null && i<tab.size(); i++) {
				if (tab.get(i) instanceof AdvancedPropertySheetSection) {
					try {
						tab.refresh(i);
					} catch (Exception e) {	}
					break;
				}
			}			
		}
	}
	
	private class TabWrapper {
		private Object[] tabContents = null;
		public TabWrapper(Object viewer) {
			try {
				Method getTabMethod = viewer.getClass().getMethod("getCurrentTab", null);
				Object tab = (Object) getTabMethod.invoke(viewer, null);
				
				Method method = tab.getClass().getMethod("getSections",null);
				tabContents = (Object[]) method.invoke(tab, null);
			} catch (Exception e) {}
		}
		public Object get(int pos) {
			return tabContents[pos];
		}
		public int size() {
			return tabContents != null ? tabContents.length : 0;
		}
		public void refresh(int pos) {
			try {
				Method method = tabContents[pos].getClass().getMethod("refresh", null);
				method.invoke(tabContents[pos], null);            
			} catch (Exception e) {}
		}
	}

	public Object getAdapter(Class key) {
		if (key.equals(IPropertySource.class)) {
			Object object = Platform.getAdapterManager().getAdapter(getModel(), key);
			if (object instanceof AbstractComponentPropertySource) {
				((AbstractComponentPropertySource)object).setCommandStack(getViewer().getEditDomain().getCommandStack());
			}else if (object instanceof LayoutPropertySource) {
				((LayoutPropertySource)object).setCommandStack(getViewer().getEditDomain().getCommandStack());
			}else if (object instanceof DynaBeanPropertySource) {
				((DynaBeanPropertySource)object).setCommandStack(getViewer().getEditDomain().getCommandStack());
			} 
			return object;
		} else if (key.equals(SnapToHelper.class)) {
			ArrayList list = new ArrayList();
			Object gird = getViewer().getProperty(SnapToGrid.PROPERTY_GRID_ENABLED);
			if (gird instanceof Boolean && ((Boolean) gird).booleanValue()) {
				list.add(new SnapToGrid(this));
			}
			Object snap = getViewer().getProperty(SnapToGeometry.PROPERTY_SNAP_ENABLED);
			if (snap instanceof Boolean && ((Boolean) snap).booleanValue()) {
				list.add(new SnapToGeometry(this));
			}
			if (list.size() > 0) {
				return new CompoundSnapToHelper(
					(SnapToHelper[]) list.toArray(new SnapToHelper[0]));
			}
		} else if (key.equals(LabelDirectEditable.class) &&
					this instanceof LabelDirectEditable) {
			return this;
		} else if (key.equals(IdDirectEditable.class) &&
					this instanceof IdDirectEditable) {
			return this;
		} else if (key.isAssignableFrom(getModel().getClass())) {
			return getModel();
		} else if (key.equals(CommandStack.class)) {
			return getViewer().getEditDomain().getCommandStack();
		}
		return super.getAdapter(key);
	}
	
	public Command createConstrainCommand(Object model, Rectangle constraint) {
		if (model instanceof Component) {
			return  new ChangeConstraintCommand((Component) model, constraint);
		}
		return null;
	}

	public Command getCreateCommand(Object parent, Object node) {
		return  new AddComponentCommand((Component) parent, (Component) node);
	}
	
	public void performRequest(Request req) {
		if (getAdapter(LabelDirectEditable.class) != null) {
			if (REQ_OPEN.equals(req.getType())) {
				new TextDirectEditManager(this, null, 
					new TextCellEditorLocator(getFigure())).show();
		
			}
		}
	}
	
	/**
	 *  このEditPartが有するモデルに対してWidgetが登録できるか判定する
	 *  
	 * @param widget 登録させたい子Widget
	 * @return 登録可能 true, 登録することができない false
	 */
	public boolean canAddChild(Object widget) {
		/* 親がDynaComponentの場合 */
		if (getModel() instanceof DynaComponent) {
			DynaComponentClass dynaClass = (DynaComponentClass)
				((DynaComponent) getModel()).getDynaClass();
			
			String namespaceURI = null;
			String name = ((Component) widget).getName();
			
			/* DynaComponetの親に追加される子がDynaComponentの場合 */
			if (widget instanceof DynaComponent) {
				DynaComponentClass child = (DynaComponentClass)
					((DynaComponent) widget).getDynaClass();
				name = child.getName();
				namespaceURI = child.getLibrary().getNamespaceURI();
				
				if (child.isItem() && dynaClass.isContainer()) {
					return false;
				}
			}
			return dynaClass.isAddChildWidget(namespaceURI, name);
			
		/* 親が独自モデルの場合 */
		} else if (getModel() instanceof Container) {
			/* 独自モデルの親に追加される子がDynaComponentの場合 */
			if (widget instanceof DynaComponent) {
				DynaComponentClass child = (DynaComponentClass)
					((DynaComponent) widget).getDynaClass();
				return !child.isItem();
			}
			return true;
		}
		return false;
	}
	
	/**
	 * このEditPartが親に登録できるか判定する
	 * 
	 * @param parent 登録したい親Widget
	 * @return 登録可能 ture, 登録することができない false
	 */
	public boolean canAddParent(Object parent) {
		return true;
	}
	
	public boolean canCopy() {
		return false;
	}
	
	public boolean canDelete() {
		return true;
	}
	
	public String getOutlineLabel() {
		Object model = getModel();
		StringBuffer sb = new StringBuffer(" "); //$NON-NLS-1$
		String name = ((Component) model).getName();
		if (name != null && !"".equals(name)) { //$NON-NLS-1$
			sb.append(((Component) model).getName());
			sb.append(" - "); //$NON-NLS-1$
		}
		String className = null;
		if (model instanceof DynaComponent) {
			DynaComponentClass dynaClass = (DynaComponentClass)
				((DynaComponent) model).getDynaClass();
//			className = dynaClass.getQualifiedName();
			className = dynaClass.getName();
		
		} else {
			className = model.getClass().getName();
		}
		className = className.substring(className.lastIndexOf(".") + 1); //$NON-NLS-1$
//		sb.append("<");
		sb.append(className);
//		sb.append(">");
		
		LabelDirectEditable direct = (LabelDirectEditable)
		getAdapter(LabelDirectEditable.class);

		if (direct != null) {
			sb.append(" - ("); //$NON-NLS-1$
			String v = direct.getLabel();
			sb.append(v == null ? "" : v); //$NON-NLS-1$
			sb.append(")"); //$NON-NLS-1$
		}
		return sb.toString();
	}
	
}
