/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper;

import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.EventTreeNode;


public class EventTreeNodeWrapper extends AbstractTreeNode
{
	public EventTreeNodeWrapper(Event event) {
		super(event);
	}

	/**
	 * for the root node, recreate it's children when refresh;
	 * cause the EventHandlerDetailsPage using this to update the treeview.
	 */
	public Object[] getElements() {
		clearChildren();
		loadChildren();
		return getChildren();
	}
	
	protected void loadChildren() {
		if (!((Event) maskatElement).isEnable()) {
			addChild(new EventTreeNode(((Event) maskatElement)));
		} else if (((Event) maskatElement).getType().equals("remote")) {
			addChild(new EventTreeNode(((Event) maskatElement)));
			addChild(new MessageToBeSentTreeNode((Event) maskatElement));
			addChild(new MessageToBeReceivedTreeNode((Event) maskatElement));
		} else if (((Event) maskatElement).getType().equals("local")) {
			addChild(new EventTreeNode(((Event) maskatElement)));
		}
	}

	public String getDisplayText() {
		return "root";
	}
}
