/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper;

import java.util.List;

import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.Param;
import jp.sf.maskat.core.event.Source;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.ParamTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.command.AddTreeNodeCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;


public class MessageToBeSentTreeNode extends AbstractTreeNode{

	private static final String MESSAGE_TOBE_SEND =
		Messages.getString("messageToBeSentTreeNode.messageTobeSend"); //$NON-NLS-1$		

	private static final String ADD_MESSAGE_CONTENT =
		Messages.getString("messageToBeSentTreeNode.addMessageContent"); //$NON-NLS-1$
	
	public MessageToBeSentTreeNode(Event event) {
		super(event);
	}

	protected void loadChildren() {
		if(shouldLoadChildren()) {
			ParamTreeNode child = new ParamTreeNode(((Event)maskatElement).getParam());
			addChild(child);
		}
	}

	private boolean shouldLoadChildren() {
		List params = maskatElement.getTypedChildren(Param.class);
		return params.size() > 0 && ((Param) params.get(0)).isEnable();
	}
	
	/**destroy the param bean of the child after remove the child*/
	public void removeChild(ITreeNode child) {
		super.removeChild(child);
		maskatElement.removeChild(child.getModel());
	}
	
	/**add the model relation when add child*/
	public void addChild(ITreeNode child) {
		super.addChild(child);
		List params = maskatElement.getTypedChildren(Param.class);
		if (params.size() > 0) {
			maskatElement.addChild(child.getModel());
		} else {
			//Param param = (Param)itParam.next();
			Param temp = (Param)child.getModel();
			List sources = temp.getTypedChildren(Source.class);
			for (int i = 0; i < sources.size(); i++) {
				((Param) params.get(0)).addChild(sources.get(i));
			}
		}
		((Event)maskatElement).getParam().setEnable(true);
	}
	
	public boolean isDeletable() {
		return false;
	}

	public String getDisplayText() {
		return MESSAGE_TOBE_SEND;
	}
	
	public IMenuManager fillContextMenu(final TreeViewer treeViewer, IMenuManager manager) {
		final ITreeNode node = this;
		if (getChildren().length == 0) {
			manager.add(new Action(ADD_MESSAGE_CONTENT){
				public void run() {
					Param param = ((Event)maskatElement).getParam();
					param.setEnable(true);
					ITreeNode childNode = new ParamTreeNode(param);
					EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer,node,childNode));
				}
			});
		}
		return manager;
	}
}
