/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.editors.layout.commands.AddBasicDefCommand;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.LabelDirectEditable;
import jp.sf.maskat.ui.editors.layout.editpolicies.DataBindingEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.LabelDirectEditPolicy;
import jp.sf.maskat.widget.rialto.editpolicy.ComboItemEditPolicy;
import jp.sf.maskat.widget.rialto.figure.ComboItemFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Font;


public class ComboItemEditPart extends ComponentEditPart
	implements LabelDirectEditable {
		
	public static final int DEFAULT_HEIGHT = 20;
	public static Font DEFAULT_FONT = new Font(null, "Arial", 8, 0);

	public void activate() {
		this.addEditPartListener(new EditPartListener.Stub() {
			public void selectedStateChanged(EditPart part) {
				MaskatElement comboDef = ((LayoutElement) ComboItemEditPart.this.getModel())
						.getParent();
				if (comboDef.getChildIdx(ComboItemEditPart.this.getModel()) == -1) {
					return;
				}
				/* 
				 * The comboItem has been removed from the parent,
				 * so don't refresh here.
				 * One refresh of editpart here will remove the editpart of
				 * comboitem from combo's, which should be the job of the
				 * DelComboItemCommand.
				 */
				if (part.getSelected() == SELECTED_NONE) {
					((ComboEditPart) ComboItemEditPart.this.getParent()).setShowChildren(false);
				} else {
					((ComboEditPart) ComboItemEditPart.this.getParent()).setShowChildren(true);
				}
				super.selectedStateChanged(part);
			}
		});
		Component model = (Component) getModel();
		model.addPropertyChangeListener(this);
		super.activate();
	}

	protected IFigure createFigure() {
		return new ComboItemFigure(getLabel());
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new ComboItemEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new LabelDirectEditPolicy());
		installEditPolicy(DataBindingEditPolicy.ROLE, new DataBindingEditPolicy());
	}

	protected void refreshVisuals() {
		((Label) getFigure()).setText(getLabel());

		ComboEditPart comboEditPart = (ComboEditPart) this.getParent();
		if (comboEditPart != null) {
			Component combo = (Component) comboEditPart.getModel();
			Rectangle constraint = new Rectangle();

			int height = Math.max(comboEditPart.getHeightItem(),
				ComboEditPart.MIN_HEIGHT_ITEM);
			int idx = combo.getChildIdx(this.getModel());
			constraint.setLocation(0, DEFAULT_HEIGHT + idx * height);
		
			constraint.setSize(combo.getWidth() - 1, height - 1);
		
			((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),constraint);
		}
	}

	public String getLabel() {
		return (String) ((DynaComponent) getModel()).get("text");
	}

	public void setLabel(String text) {
		((DynaComponent) getModel()).set("text", text);
	}
	
	public Command createConstrainCommand(EditPart editPart, Rectangle constraint) {
		return null;
	}
	
	public Command getCreateCommand(Object parent, Object node) {
		return  new AddBasicDefCommand((LayoutElement) parent, (LayoutElement) node);
	}
}
