/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.HorizontalResizable;
import jp.sf.maskat.ui.editors.layout.editparts.IdDirectEditable;
import jp.sf.maskat.ui.editors.layout.editparts.LabelDirectEditable;
import jp.sf.maskat.ui.editors.layout.editpolicies.ComponentXYLayoutEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.FeedBackComponentEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.LabelDirectEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.MaskatComponentEditPolicy;
import jp.sf.maskat.widget.rialto.commands.AddGridHeaderCommand;
import jp.sf.maskat.widget.rialto.commands.ChangeGridHeaderWidthCommand;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;


public class GridHeaderEditPart extends ComponentEditPart
	implements LabelDirectEditable, HorizontalResizable {

	public static final int headerHeight = 20;

	public static final int headerTop = 20;

	public static final int minimalHeaderDisplayWidth = 10;

	protected IFigure createFigure() {
		Label label = new Label();
		label.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(0)));
		label.setLayoutManager(new XYLayout());
		return label;
	}

	protected void createEditPolicies() {
		int style = FeedBackComponentEditPolicy.getStyle(this);
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new MaskatComponentEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new ComponentXYLayoutEditPolicy(style));
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new LabelDirectEditPolicy());
		installEditPolicy("Snap Feedback", new SnapFeedbackPolicy());
	}

	protected void refreshVisuals() {
		((Label) this.getFigure()).setText(getLabel());

		// gridHeaderDefの場合、setLayoutConstraintのconstraintを計算
		
		Component gridHeader = (Component) getModel();
		int idx = idxInParent();
		int left = 0;
		List headers = ((GridEditPart) getParent()).getHeadersIt();
		for (int i = 0; i < idx; i++) {
			int headerWidth = toHeaderDisplayWidth(
					((Component) ((GridHeaderEditPart) headers.get(i)).getModel()).getWidth());
			left += headerWidth;			
		}
		Rectangle constraint = new Rectangle(left, headerTop,
				toHeaderDisplayWidth(gridHeader.getWidth()), headerHeight);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}
	public void propertyChange(PropertyChangeEvent evt) {
		if ("width".equals(evt.getPropertyName())) {
			((GridEditPart) getParent()).refreshGridWidget();
		} else if ("title".equals(evt.getPropertyName())) {
			Label figure = (Label) getFigure();
			figure.setText(getLabel());
			super.propertyChange(evt);
		}
	}
	
	/**
	 * gridヘッダー表示用の幅を返す（minimalHeaderDisplayWidth以下であれば、minimalHeaderDisplayWidthを返す）,
	 * つまり、gridヘッダーの表示幅最小限を限定
	 * 
	 * @param headerWidth
	 * @return
	 */
	public static int toHeaderDisplayWidth(int headerWidth) {
		return Math.max(headerWidth, minimalHeaderDisplayWidth);
	}

	public int idxInParent() {
		GridEditPart parent = (GridEditPart) getParent();
		return (parent == null) ? -1 : parent.indexOfHeader(this);
	}

	public Object getAdapter(Class key) {
		if (key.equals(IdDirectEditable.class)) {
			return null;
		}
		return super.getAdapter(key);
	}

	public boolean canAddChild(Object widget) {
		if (widget instanceof DynaComponent) {
			DynaComponentClass child = (DynaComponentClass)
				((DynaComponent) widget).getDynaClass();

			DynaComponentClass dynaClass = (DynaComponentClass)
				((DynaComponent) getModel()).getDynaClass();
			
			if (dynaClass.getLibrary() == child.getLibrary() &&
				"gridCellCombo".equals(child.getName())) {
				return true;
			}
		}
		return false;
	}
	
	public String getLabel() {
		return (String) ((DynaComponent) getModel()).get("title");
	}

	public void setLabel(String text) {
		((DynaComponent) getModel()).set("title", text);
	}
	
	public Command createConstrainCommand(Object model, Rectangle constraint) {
		return  new ChangeGridHeaderWidthCommand((Component) model, constraint);
	}

	public Command getCreateCommand(Object parent, Object node) {
		return  new AddGridHeaderCommand((Component) parent, (Component) node);
	}
}
