/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.figure;

import jp.sf.maskat.widget.rialto.RialtoPlugin;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ComboFigure extends Label {

	public static final int DEFAULT_HEIGHT = 20;

	public static Font DEFAULT_FONT = new Font(null, "Arial", 8, 0);
	
	private boolean isChildrenShown;

	public boolean isChildrenShown() {
		return isChildrenShown;
	}

	public void setChildrenShown(boolean isChildrenShow) {
		this.isChildrenShown = isChildrenShow;
	}

	public ComboFigure() {
		super("     ", RialtoPlugin.getImage(
				RialtoPlugin.IMG_COMBOBOXDROPDOWN));
//		super();
//		setIcon(RialtoPlugin.getImage(RialtoPlugin.IMG_COMBOBOXDROPDOWN));
//		setIconAlignment(PositionConstants.RIGHT);
		setForegroundColor(ColorConstants.black);
		setFont(DEFAULT_FONT);
		setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(0)));
		setTextAlignment(PositionConstants.TOP);
		setTextPlacement(PositionConstants.WEST);
		setOpaque(false);
		setLayoutManager(new XYLayout());
	}

	public ComboFigure(String s) {
		super(s);
	}

	public ComboFigure(Image i) {
		super(i);
	}

	public ComboFigure(String s, Image i) {
		super(s, i);
	}
}
