/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.event;

/**
 * 繰り返し利用可能なリモートイベントを定義するクラスです
 * Event要素のref属性で参照用として定義されます
 */
public class EventRef extends Event {

	/**
	 * 参照用イベント定義名
	 */
	private String refid;

	/**
	 * 参照用イベント定義名を取得します
	 * 
	 * @return 参照用イベント定義名
	 */
	public String getRefid() {
		return refid;
	}

	/**
	 * 参照用イベント定義名を設定します
	 * 
	 * @param refId 参照用イベント定義名
	 */
	public void setRefid(String refId) {
		this.refid = refId;
	}
}
