/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.event;

/**
 * HTTP要求時に付与するHTTPヘッダクラスです
 *
 * このヘッダクラスは以下の２つの定義の仕方があります
 * 
 * １）eventDefの子要素として定義した場合、すべての通信時に
 *     指定したHTTPヘッダが付与されます。
 * ２）eventもしくはeventRefの子要素として定義した場合、その
 *     イベントの通信時のみHTTPヘッダが付与されます。
 */
public class Header extends AbstractEventElement {

	/**
	 * HTTPヘッダのフィールド名
	 */
	private String name;

	/**
	 * 	HTTPヘッダのフィールド値
	 */
	private String value;

	/**
	 * デフォルトコンストラクタです
	 */
	public Header() {
		super();
	}
	
	/**
	 * HTTPヘッダのフィールド名を取得します
	 * 
	 * @return HTTPヘッダのフィールド名
	 */
	public String getName() {
		return name;
	}

	/**
	 * HTTPヘッダのフィールド名を設定します
	 * 
	 * @param name HTTPヘッダのフィールド名
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * HTTPヘッダのフィールド値を取得します
	 * 
	 * @return HTTPヘッダのフィールド値
	 */
	public String getValue() {
		return value;
	}

	/**
	 * HTTPヘッダのフィールド値を設定します
	 * 
	 * @param value HTTPヘッダのフィールド値
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * ハッシュコードを取得します
	 * 
	 * HeaderクラスのハッシュコードはHTTPヘッダのフィールド名
	 * から求められます。
	 */
	public int hashCode() {
		return (name == null ? 0 : name.hashCode())
				+ (value == null ? 0 : value.hashCode());
	}
}

