/*
 * Copyright (c) 2006-2010 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.ui;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * ワークスペース全体で共通なプレファレンスストアの初期化を行うクラスです
 *
 * レイアウトエディタのパレット情報を初期化します。
 */
public class MaskatUIPreferenceInitializer
		extends AbstractPreferenceInitializer {

	/**
	 * ワークスペース全体で共通なプレファレンスストアの初期化を行います
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = MaskatUIPlugin.getDefault()
				.getPreferenceStore();
		store.setDefault(PreferenceConstants.PALETTE_ENTRIES, "");
	}
}
